/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ExpandedItemListCellRendererWrapper<T>
implements ListCellRenderer<T> {
    @NotNull
    private final ListCellRenderer<T> myWrappee;
    @NotNull
    private final ExpandableItemsHandler<Integer> myHandler;

    public ExpandedItemListCellRendererWrapper(@NotNull ListCellRenderer<T> wrappee, @NotNull ExpandableItemsHandler<Integer> handler) {
        if (wrappee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappee", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "<init>"));
        }
        this.myWrappee = wrappee;
        this.myHandler = handler;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        GraphicsUtil.setAntialiasingType(list, (Object)AntialiasingType.getAAHintForSwingComponent());
        Component result = this.myWrappee.getListCellRendererComponent(list, UIUtil.htmlInjectionGuard(value), index, isSelected, cellHasFocus);
        if (!this.myHandler.getExpandedItems().contains(index)) {
            return result;
        }
        Rectangle bounds = result.getBounds();
        ExpandedItemRendererComponentWrapper wrapper = ExpandedItemRendererComponentWrapper.wrap(result);
        if (UIUtil.isClientPropertyTrue(list, ExpandableItemsHandler.EXPANDED_RENDERER) && UIUtil.isClientPropertyTrue((Object)result, ExpandableItemsHandler.USE_RENDERER_BOUNDS)) {
            wrapper.setBounds(bounds);
            UIUtil.putClientProperty((JComponent)wrapper, ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)true);
        }
        wrapper.owner = list;
        return wrapper;
    }

    public String toString() {
        return "ExpandedItemListCellRendererWrapper[" + this.getWrappee().getClass().getName() + "]";
    }

    @NotNull
    public ListCellRenderer getWrappee() {
        ListCellRenderer<T> listCellRenderer = this.myWrappee;
        if (listCellRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/ExpandedItemListCellRendererWrapper", "getWrappee"));
        }
        return listCellRenderer;
    }
}

