/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TextAccessor;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.jetbrains.annotations.Nullable;

public class RawCommandLineEditor
extends JPanel
implements TextAccessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.RawCommandLineEditor");
    private final TextFieldWithBrowseButton myTextField;
    private String myDialogCaption = "";

    public RawCommandLineEditor() {
        this((Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public RawCommandLineEditor(final Function<String, List<String>> lineParser, final Function<List<String>, String> lineJoiner) {
        super(new BorderLayout());
        this.myTextField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RawCommandLineEditor.this.myDialogCaption == null) {
                    Container parent = RawCommandLineEditor.this.getParent();
                    if (parent instanceof LabeledComponent) {
                        parent = parent.getParent();
                    }
                    LOG.error("Did not call RawCommandLineEditor.setDialogCaption() in " + parent);
                    RawCommandLineEditor.this.myDialogCaption = "Parameters";
                }
                Messages.showTextAreaDialog(RawCommandLineEditor.this.myTextField.getTextField(), RawCommandLineEditor.this.myDialogCaption, "EditParametersPopupWindow", (Function<String, List<String>>)lineParser, (Function<List<String>, String>)lineJoiner);
            }
        });
        this.myTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.add((Component)this.myTextField, "Center");
        this.setDescriptor(null);
    }

    public void setDescriptor(FileChooserDescriptor descriptor) {
        InsertPathAction.addTo(this.myTextField.getTextField(), descriptor);
    }

    public String getDialogCaption() {
        return this.myDialogCaption;
    }

    public void setDialogCaption(String dialogCaption) {
        this.myDialogCaption = dialogCaption != null ? dialogCaption : "";
    }

    @Override
    public void setText(@Nullable String text) {
        this.myTextField.setText(text);
    }

    @Override
    public String getText() {
        return this.myTextField.getText();
    }

    public JTextField getTextField() {
        return this.myTextField.getTextField();
    }

    public Document getDocument() {
        return this.myTextField.getTextField().getDocument();
    }

    public void attachLabel(JLabel label) {
        label.setLabelFor(this.myTextField.getTextField());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTextField.setEnabled(enabled);
    }
}

