/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usages.UsageView;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class Node
extends DefaultMutableTreeNode {
    private int myCachedTextHash;
    private byte myCachedFlags;
    static final byte EXCLUDED_MASK = 8;
    private static final byte UPDATED_MASK = 16;
    private static final byte CACHED_INVALID_MASK = 1;
    private static final byte CACHED_READ_ONLY_MASK = 2;
    private static final byte READ_ONLY_COMPUTED_MASK = 4;

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myCachedFlags, (byte)mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value) {
        this.myCachedFlags = BitUtil.set((byte)this.myCachedFlags, (byte)mask, (boolean)value);
    }

    Node() {
    }

    public abstract String tree2string(int var1, String var2);

    protected abstract boolean isDataValid();

    protected abstract boolean isDataReadOnly();

    protected abstract boolean isDataExcluded();

    @NotNull
    protected abstract String getText(@NotNull UsageView var1);

    public final boolean isValid() {
        return !this.isFlagSet((byte)1);
    }

    public final boolean isReadOnly() {
        boolean result;
        boolean computed = this.isFlagSet((byte)4);
        if (computed) {
            result = this.isFlagSet((byte)2);
        } else {
            result = this.isDataReadOnly();
            this.setFlag((byte)4, true);
            this.setFlag((byte)2, result);
        }
        return result;
    }

    public final boolean isExcluded() {
        return this.isFlagSet((byte)8);
    }

    final synchronized void update(@NotNull UsageView view, @NotNull Consumer<Node> edtNodeChangedQueue) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/Node", "update"));
        }
        if (edtNodeChangedQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtNodeChangedQueue", "com/intellij/usages/impl/Node", "update"));
        }
        boolean isDataValid = this.isDataValid();
        boolean isReadOnly = this.isDataReadOnly();
        String text = this.getText(view);
        boolean cachedValid = this.isValid();
        boolean cachedReadOnly = this.isFlagSet((byte)2);
        if (isDataValid != cachedValid || isReadOnly != cachedReadOnly || this.myCachedTextHash != text.hashCode()) {
            this.setFlag((byte)1, !isDataValid);
            this.setFlag((byte)2, isReadOnly);
            this.myCachedTextHash = text.hashCode();
            this.updateNotify();
            edtNodeChangedQueue.consume((Object)this);
        }
        this.setFlag((byte)16, true);
    }

    void markNeedUpdate() {
        this.setFlag((byte)16, false);
    }

    boolean needsUpdate() {
        return !this.isFlagSet((byte)16);
    }

    protected void updateNotify() {
    }

    void insertNewNode(@NotNull Node newChild, int childIndex) {
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/intellij/usages/impl/Node", "insertNewNode"));
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    void setExcluded(boolean excluded, @NotNull Consumer<Node> edtNodeChangedQueue) {
        if (edtNodeChangedQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtNodeChangedQueue", "com/intellij/usages/impl/Node", "setExcluded"));
        }
        this.setFlag((byte)8, excluded);
        edtNodeChangedQueue.consume((Object)this);
    }

    private static @interface FlagConstant {
    }
}

