/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;

public class CountingGZIPInputStream
extends GZIPInputStream {
    private final CountingInputStream myInputStream;

    private CountingGZIPInputStream(@NotNull CountingInputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/CountingGZIPInputStream", "<init>"));
        }
        super(inputStream);
        this.myInputStream = inputStream;
    }

    public long getCompressedBytesRead() {
        return this.myInputStream.myBytesRead;
    }

    @NotNull
    public static CountingGZIPInputStream create(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/CountingGZIPInputStream", "create"));
        }
        CountingGZIPInputStream countingGZIPInputStream = new CountingGZIPInputStream(new CountingInputStream(inputStream));
        if (countingGZIPInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/CountingGZIPInputStream", "create"));
        }
        return countingGZIPInputStream;
    }

    private static class CountingInputStream
    extends InputStream {
        private final InputStream myInputStream;
        private long myBytesRead;

        public CountingInputStream(@NotNull InputStream inputStream) {
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/util/io/CountingGZIPInputStream$CountingInputStream", "<init>"));
            }
            this.myBytesRead = 0L;
            this.myInputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            int data = this.myInputStream.read();
            ++this.myBytesRead;
            return data;
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/CountingGZIPInputStream$CountingInputStream", "read"));
            }
            int bytesRead = this.myInputStream.read(b);
            this.myBytesRead += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/util/io/CountingGZIPInputStream$CountingInputStream", "read"));
            }
            int bytesRead = this.myInputStream.read(b, off, len);
            this.myBytesRead += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long bytesSkipped = this.myInputStream.skip(n);
            this.myBytesRead += bytesSkipped;
            return bytesSkipped;
        }

        @Override
        public int available() throws IOException {
            return this.myInputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.myInputStream.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.myInputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.myInputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.myInputStream.markSupported();
        }
    }
}

