/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    protected final String myName;

    public AddDomElementQuickFix(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/highlighting/AddDomElementQuickFix", "<init>"));
        }
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/AddDomElementQuickFix", "getName"));
        }
        return string;
    }

    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return DomBundle.message(this.isTag() ? "add.element.fix.name" : "add.attribute.fix.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = DomBundle.message("add.element.fix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/AddDomElementQuickFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/xml/highlighting/AddDomElementQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/util/xml/highlighting/AddDomElementQuickFix", "applyFix"));
        }
        XmlElement element = this.myElement.ensureXmlElementExists();
        XmlElement navigationElement = this.isTag() ? element : ((XmlAttribute)element).getValueElement();
        PsiNavigateUtil.navigate(navigationElement);
    }
}

