/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyLocalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        if ("Local variable naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "getDisplayName"));
        }
        return "Local variable naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "buildFix"));
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Local variable name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "buildErrorString"));
            }
            return "Local variable name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Local variable name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "buildErrorString"));
            }
            return "Local variable name '#ref' is too long";
        }
        String string = "Local variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        NamingConventionsVisitor namingConventionsVisitor = new NamingConventionsVisitor();
        if (namingConventionsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection", "buildVisitor"));
        }
        return namingConventionsVisitor;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitVariable(@NotNull GrVariable grVariable) {
            if (grVariable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grVariable", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection$NamingConventionsVisitor", "visitVariable"));
            }
            super.visitVariable(grVariable);
            if (grVariable instanceof GrField || grVariable instanceof GrParameter) {
                return;
            }
            String name = grVariable.getName();
            if (GroovyLocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grVariable, name);
        }

        @Override
        public void visitParameter(@NotNull GrParameter grParameter) {
            if (grParameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grParameter", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyLocalVariableNamingConventionInspection$NamingConventionsVisitor", "visitParameter"));
            }
            super.visitParameter(grParameter);
            String name = grParameter.getName();
            PsiElement scope = grParameter.getDeclarationScope();
            if (!(scope instanceof GrCatchClause) && !(scope instanceof GrForStatement)) {
                return;
            }
            if (GroovyLocalVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grParameter, name);
        }
    }
}

