/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

class GroovyWordsScanner
extends VersionedWordsScanner {
    private final Lexer myLexer = new GroovyLexer();

    public void processWords(CharSequence fileText, Processor<WordOccurrence> processor) {
        this.myLexer.start(fileText);
        WordOccurrence occurrence = null;
        while (this.myLexer.getTokenType() != null) {
            IElementType type = this.myLexer.getTokenType();
            if (type == GroovyTokenTypes.mIDENT || TokenSets.KEYWORDS.contains(type)) {
                if (occurrence == null) {
                    occurrence = new WordOccurrence(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                } else {
                    occurrence.init(fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE);
                }
                if (!processor.process((Object)occurrence)) {
                    return;
                }
            } else if (TokenSets.COMMENT_SET.contains(type)) {
                if (!GroovyWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.COMMENTS, occurrence)) {
                    return;
                }
            } else if (TokenSets.STRING_LITERALS.contains(type)) {
                if (!GroovyWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.LITERALS, occurrence)) {
                    return;
                }
                if (type == GroovyTokenTypes.mSTRING_LITERAL && !GroovyWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), WordOccurrence.Kind.CODE, occurrence)) {
                    return;
                }
            } else if (!GroovyWordsScanner.stripWords(processor, fileText, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), null, occurrence)) {
                return;
            }
            this.myLexer.advance();
        }
    }

    public int getVersion() {
        return 2;
    }

    private static boolean stripWords(Processor<WordOccurrence> processor, CharSequence tokenText, int from, int to, WordOccurrence.Kind kind, WordOccurrence occurrence) {
        int index = from;
        while (index != to) {
            char c;
            char c2 = tokenText.charAt(index);
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || Character.isJavaIdentifierStart(c2) && c2 != '$')) {
                ++index;
                continue;
            }
            int index1 = index;
            while (++index != to && ((c = tokenText.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierPart(c) && c != '$')) {
            }
            if (occurrence == null) {
                occurrence = new WordOccurrence(tokenText, index1, index, kind);
            } else {
                occurrence.init(tokenText, index1, index, kind);
            }
            if (processor.process((Object)occurrence)) continue;
            return false;
        }
        return true;
    }
}

