/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "buildLanguageFoldRegions"));
        }
        this.appendDescriptors(root, descriptors, (Set<PsiElement>)new HashSet());
    }

    private void appendDescriptors(PsiElement element, List<FoldingDescriptor> descriptors, Set<PsiElement> usedComments) {
        ASTNode node = element.getNode();
        if (node == null) {
            return;
        }
        IElementType type = node.getElementType();
        if ((TokenSets.BLOCK_SET.contains(type) && !GroovyFoldingBuilder.isSingleHighLevelClassBody(element) || type == GroovyElementTypes.CLOSABLE_BLOCK) && GroovyFoldingBuilder.isMultiline(element)) {
            GroovyFoldingBuilder.collapseBlock(descriptors, element);
        }
        if ((type.equals(GroovyTokenTypes.mML_COMMENT) || type.equals(GroovyDocElementTypes.GROOVY_DOC_COMMENT)) && GroovyFoldingBuilder.isMultiline(element) && GroovyFoldingBuilder.isWellEndedComment(element)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
        if (type.equals(GroovyTokenTypes.mSL_COMMENT) && usedComments.add(element) && !GroovyFoldingBuilder.isCustomRegionElement((PsiElement)element)) {
            PsiElement end = null;
            for (PsiElement current = element.getNextSibling(); current != null; current = current.getNextSibling()) {
                if (PsiImplUtil.isWhiteSpaceOrNls(current)) continue;
                IElementType elementType = current.getNode().getElementType();
                if (elementType != GroovyTokenTypes.mSL_COMMENT || !usedComments.add(current) || GroovyFoldingBuilder.isCustomRegionElement((PsiElement)current)) break;
                end = current;
            }
            if (end != null) {
                TextRange range = new TextRange(element.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
                descriptors.add(new FoldingDescriptor(element, range));
            }
        }
        GroovyFoldingBuilder.addFoldingForStrings(descriptors, node);
        HashSet newUsedComments = new HashSet();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.appendDescriptors(child, descriptors, (Set<PsiElement>)newUsedComments);
        }
        if (element instanceof GroovyFile) {
            GroovyFoldingBuilder.processImports(descriptors, ((GroovyFile)element).getImportStatements());
        }
    }

    private static void collapseBlock(List<FoldingDescriptor> descriptors, PsiElement psi) {
        int lineFeedCount;
        if (psi instanceof GrCodeBlock && (lineFeedCount = StringUtil.countChars((CharSequence)psi.getText(), (char)'\n')) <= 2) {
            PsiElement lbrace = ((GrCodeBlock)psi).getLBrace();
            PsiElement rbrace = ((GrCodeBlock)psi).getRBrace();
            if (lbrace != null && rbrace != null) {
                PsiElement next = lbrace.getNextSibling();
                PsiElement prev = rbrace.getPrevSibling();
                if (next != null && PsiImplUtil.isWhiteSpaceOrNls(next) && prev != null && PsiImplUtil.isWhiteSpaceOrNls(prev)) {
                    FoldingGroup group = FoldingGroup.newGroup((String)"block_group");
                    descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(psi, lbrace.getTextRange().getStartOffset(), next.getTextRange().getEndOffset(), group, "{"));
                    descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(psi, prev.getTextRange().getStartOffset(), rbrace.getTextRange().getEndOffset(), group, "}"));
                    return;
                }
            }
        }
        descriptors.add(new FoldingDescriptor(psi, psi.getTextRange()));
    }

    private static boolean isSingleHighLevelClassBody(PsiElement element) {
        if (!(element instanceof GrTypeDefinitionBody)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrTypeDefinition)) {
            return false;
        }
        GrTypeDefinition clazz = (GrTypeDefinition)parent;
        if (clazz.isAnonymous() || clazz.getContainingClass() != null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        return file instanceof GroovyFile && ((GroovyFile)file).getClasses().length == 1;
    }

    private static void addFoldingForStrings(List<FoldingDescriptor> descriptors, ASTNode node) {
        GrStringInjection injection;
        TextRange injectionRange;
        if (!GroovyFoldingBuilder.isMultiLineStringLiteral(node)) {
            return;
        }
        if (!node.getElementType().equals((Object)GroovyElementTypes.GSTRING) && !node.getElementType().equals((Object)GroovyElementTypes.REGEX)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
            return;
        }
        GrString grString = (GrString)node.getPsi();
        if (grString == null) {
            return;
        }
        GrStringInjection[] injections = grString.getInjections();
        if (injections.length == 0) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
            return;
        }
        String start_quote = GrStringUtil.getStartQuote(node.getText());
        String end_quote = GrStringUtil.getEndQuote(node.getText());
        FoldingGroup group = FoldingGroup.newGroup((String)"GString");
        TextRange nodeRange = node.getTextRange();
        int startOffset = nodeRange.getStartOffset();
        if (startOffset + 1 < (injectionRange = (injection = injections[0]).getTextRange()).getStartOffset()) {
            descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(node, startOffset, injectionRange.getStartOffset(), group, start_quote));
        }
        String placeholder = " ";
        startOffset = injectionRange.getEndOffset();
        for (int i = 1; i < injections.length; ++i) {
            injection = injections[i];
            injectionRange = injection.getTextRange();
            int endOffset = injectionRange.getStartOffset();
            if (endOffset - startOffset >= 2) {
                descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(injection.getNode().getTreePrev(), startOffset, endOffset, group, " "));
            }
            startOffset = injectionRange.getEndOffset();
        }
        if (startOffset + 1 < nodeRange.getEndOffset()) {
            descriptors.add((FoldingDescriptor)new NamedFoldingDescriptor(node.getLastChildNode(), startOffset, nodeRange.getEndOffset(), group, end_quote));
        }
    }

    private static void processImports(List<FoldingDescriptor> descriptors, GrImportStatement[] imports2) {
        if (imports2.length < 2) {
            return;
        }
        GrImportStatement first = imports2[0];
        while (first != null) {
            GrImportStatement marker = first;
            PsiElement next = first.getNextSibling();
            while (next instanceof GrImportStatement || next instanceof LeafPsiElement) {
                if (next instanceof GrImportStatement) {
                    marker = next;
                }
                next = next.getNextSibling();
            }
            if (marker != first) {
                int start = first.getTextRange().getStartOffset();
                int end = marker.getTextRange().getEndOffset();
                int tail = "import ".length();
                if (start + tail < end && !JavaFoldingBuilderBase.hasErrorElementsNearby((PsiFile)first.getContainingFile(), (int)start, (int)end)) {
                    FoldingDescriptor descriptor2 = new FoldingDescriptor(first.getNode(), new TextRange(start + tail, end));
                    descriptor2.setCanBeRemovedWhenCollapsed(true);
                    descriptors.add(descriptor2);
                }
            }
            while (!(next instanceof GrImportStatement) && next != null) {
                next = next.getNextSibling();
            }
            first = next;
        }
    }

    private static boolean isWellEndedComment(PsiElement element) {
        return element.getText().endsWith("*/");
    }

    private static boolean isMultiline(PsiElement element) {
        String text = element.getText();
        return text.contains("\n") || text.contains("\r") || text.contains("\r\n");
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "getLanguagePlaceholderText"));
        }
        IElementType elemType = node.getElementType();
        if (TokenSets.BLOCK_SET.contains(elemType) || elemType == GroovyElementTypes.CLOSABLE_BLOCK) {
            return "{...}";
        }
        if (elemType.equals(GroovyTokenTypes.mML_COMMENT)) {
            return "/*...*/";
        }
        if (elemType.equals(GroovyDocElementTypes.GROOVY_DOC_COMMENT)) {
            return "/**...*/";
        }
        if (((Object)((Object)GroovyElementTypes.IMPORT_STATEMENT)).equals(elemType)) {
            return "...";
        }
        if (GroovyFoldingBuilder.isMultiLineStringLiteral(node)) {
            String start_quote = GrStringUtil.getStartQuote(node.getText());
            String end_quote = GrStringUtil.getEndQuote(node.getText());
            return start_quote + "..." + end_quote;
        }
        return null;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        PsiElement parent;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (node.getElementType() == GroovyElementTypes.IMPORT_STATEMENT) {
            return settings.isCollapseImports();
        }
        if (node.getElementType() == GroovyDocElementTypes.GROOVY_DOC_COMMENT || node.getElementType() == GroovyTokenTypes.mML_COMMENT) {
            PsiElement element = node.getPsi();
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof GroovyFile) {
                PsiElement firstChild = parent2.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            if (node.getElementType() == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
                return settings.isCollapseJavadocs();
            }
        }
        if ((node.getElementType() == GroovyElementTypes.OPEN_BLOCK || node.getElementType() == GroovyElementTypes.CONSTRUCTOR_BODY) && node.getTreeParent().getElementType() == GroovyElementTypes.METHOD_DEFINITION) {
            return settings.isCollapseMethods();
        }
        if (node.getElementType() == GroovyElementTypes.CLOSABLE_BLOCK) {
            return settings.isCollapseAnonymousClasses();
        }
        if (node.getElementType() == GroovyElementTypes.CLASS_BODY && (parent = node.getPsi().getParent()) instanceof PsiClass) {
            if (parent instanceof PsiAnonymousClass) {
                return settings.isCollapseAnonymousClasses();
            }
            if (((PsiClass)parent).getContainingClass() != null) {
                return settings.isCollapseInnerClasses();
            }
        }
        if (node.getElementType() == GroovyTokenTypes.mSL_COMMENT) {
            return settings.isCollapseEndOfLineComments();
        }
        return false;
    }

    private static boolean isMultiLineStringLiteral(ASTNode node) {
        return (TokenSets.STRING_LITERAL_SET.contains(node.getElementType()) || node.getElementType().equals((Object)GroovyElementTypes.GSTRING) || node.getElementType().equals((Object)GroovyElementTypes.REGEX)) && GroovyFoldingBuilder.isMultiline(node.getPsi()) && GrStringUtil.isWellEndedString(node.getPsi());
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "isCustomFoldingCandidate"));
        }
        return node.getElementType() == GroovyTokenTypes.mSL_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/folding/GroovyFoldingBuilder", "isCustomFoldingRoot"));
        }
        IElementType nodeType = node.getElementType();
        return nodeType == GroovyElementTypes.CLASS_DEFINITION || nodeType == GroovyElementTypes.OPEN_BLOCK;
    }
}

