/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;

public class ReturnInstruction
extends InstructionImpl {
    public ReturnInstruction(GrFinallyClause finallyClause) {
        super(finallyClause);
    }

    @Override
    public String toString() {
        return super.toString() + " RETURN";
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ReturnInstruction", "getElementPresentation"));
        }
        return "";
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ReturnInstruction", "successors"));
        }
        Deque<CallInstruction> callStack = environment.callStack(this);
        if (callStack.isEmpty()) {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ReturnInstruction", "successors"));
            }
            return list;
        }
        CallInstruction callInstruction = callStack.peek();
        Iterable<Instruction> successors = callInstruction.allSuccessors();
        ArrayDeque<CallInstruction> copy = new ArrayDeque<CallInstruction>(callStack);
        copy.pop();
        for (Instruction instruction : successors) {
            environment.update(copy, instruction);
        }
        Iterable<Instruction> iterable = successors;
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/ReturnInstruction", "successors"));
        }
        return iterable;
    }
}

