/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

class GrClosureParameterImpl
implements GrClosureParameter {
    private final PsiParameter myParameter;
    private final PsiSubstitutor mySubstitutor;
    private final boolean myEraseType;

    public GrClosureParameterImpl(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureParameterImpl", "<init>"));
        }
        this(parameter, PsiSubstitutor.EMPTY, false);
    }

    public GrClosureParameterImpl(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor, boolean eraseType) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureParameterImpl", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/signatures/GrClosureParameterImpl", "<init>"));
        }
        this.myParameter = parameter;
        this.mySubstitutor = substitutor;
        this.myEraseType = eraseType;
    }

    @Override
    @Nullable
    public PsiType getType() {
        PsiClassType[] types;
        PsiClass parameterClass;
        PsiType typeParameter = this.myParameter.getType();
        PsiType type = this.mySubstitutor.substitute(typeParameter);
        if (typeParameter instanceof PsiClassType && (parameterClass = ((PsiClassType)typeParameter).resolve()) instanceof PsiTypeParameter && type != null && (types = parameterClass.getExtendsListTypes()).length > 0 && !TypesUtil.isAssignableByMethodCallConversion((PsiType)types[0], type, (PsiElement)this.myParameter)) {
            type = types[0];
        }
        return this.myEraseType ? TypeConversionUtil.erasure((PsiType)type) : type;
    }

    @Override
    public boolean isOptional() {
        return this.myParameter instanceof GrParameter && ((GrParameter)this.myParameter).isOptional();
    }

    @Override
    @Nullable
    public GrExpression getDefaultInitializer() {
        return this.myParameter instanceof GrParameter ? ((GrParameter)this.myParameter).getInitializerGroovy() : null;
    }

    @Override
    public boolean isValid() {
        return this.myParameter.isValid();
    }

    @Override
    @Nullable
    public String getName() {
        return this.myParameter.getName();
    }
}

