/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunnerKt;
import org.jetbrains.plugins.groovy.lang.typing.GrTypeCalculator;

public abstract class GrMethodCallImpl
extends GrCallExpressionImpl
implements GrMethodCall {
    public GrMethodCallImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GrExpression invoked = this.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpression)) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "getCallVariants"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = GrReferenceResolveRunnerKt.getCallVariants((GrReferenceExpression)invoked, upToArgument);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "getCallVariants"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            GrExpression grExpression = (GrExpression)cur;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "getInvokedExpression"));
            }
            return grExpression;
        }
        throw new IncorrectOperationException("invoked expression must not be null");
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, GrTypeCalculator::getTypeFromCalculators);
    }

    @Override
    public boolean isCommandExpression() {
        GrExpression expression = this.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression) || ((GrReferenceExpression)expression).getQualifier() == null) {
            return false;
        }
        return ((GrReferenceExpression)expression).getDotToken() == null;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GrExpression expression = this.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "multiResolve"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] groovyResolveResultArray = ((GrReferenceExpression)expression).multiResolve(incompleteCode);
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    @NotNull
    public GrArgumentList getArgumentList() {
        GrArgumentList grArgumentList = (GrArgumentList)this.findNotNullChildByClass(GrArgumentList.class);
        if (grArgumentList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrMethodCallImpl", "getArgumentList"));
        }
        return grArgumentList;
    }
}

