/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class GrBindingVariable
extends GrLightVariable
implements GrVariable {
    private final GroovyFile myFile;
    private Boolean myHasWriteAccess;

    public GrBindingVariable(GroovyFile file, String name, Boolean isWriteAccess) {
        super(file.getManager(), name, "java.lang.Object", (PsiElement)file);
        this.myFile = file;
        this.myHasWriteAccess = isWriteAccess;
    }

    public PsiElement getContext() {
        return this.myFile;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JetgroovyIcons.Groovy.Variable;
    }

    @Override
    @Nullable
    public GrExpression getInitializerGroovy() {
        return null;
    }

    @Override
    public void setType(@Nullable PsiType type) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        return null;
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        return null;
    }

    @Override
    @Nullable
    public PsiType getDeclaredType() {
        return null;
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(this.getName());
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrBindingVariable", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitVariable(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
        throw new UnsupportedOperationException();
    }

    public boolean hasWriteAccess() {
        if (this.myHasWriteAccess != null) {
            return this.myHasWriteAccess;
        }
        this.myFile.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrBindingVariable$1", "visitAssignmentExpression"));
                }
                GrExpression lValue = expression.getLValue();
                if (GrBindingVariable.this.isRefToMe(lValue)) {
                    GrBindingVariable.this.myHasWriteAccess = true;
                }
                super.visitAssignmentExpression(expression);
            }

            @Override
            public void visitTuple(@NotNull GrTuple tuple) {
                if (tuple == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tuple", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrBindingVariable$1", "visitTuple"));
                }
                for (GrReferenceExpression grExpression : tuple.getExpressions()) {
                    if (!GrBindingVariable.this.isRefToMe(grExpression)) continue;
                    GrBindingVariable.this.myHasWriteAccess = true;
                    break;
                }
                super.visitTuple(tuple);
            }

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrBindingVariable$1", "visitTypeDefinition"));
                }
            }

            @Override
            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrBindingVariable$1", "visitElement"));
                }
                if (GrBindingVariable.this.myHasWriteAccess == null) {
                    super.visitElement(element);
                }
            }
        });
        if (this.myHasWriteAccess == null) {
            this.myHasWriteAccess = false;
        }
        return this.myHasWriteAccess;
    }

    private boolean isRefToMe(@Nullable PsiElement element) {
        PsiElement resolved;
        return this.maybeRefToMe(element) && ((resolved = ((GrReferenceExpression)element).resolve()) == null || resolved == this);
    }

    private boolean maybeRefToMe(PsiElement element) {
        return element instanceof GrReferenceExpression && !((GrReferenceExpression)element).isQualified() && this.getName().equals(((GrReferenceExpression)element).getReferenceName());
    }

    public void updateWriteAccessIfNeeded(@Nullable PsiElement place) {
        if (this.myHasWriteAccess == null && this.maybeRefToMe(place)) {
            assert (place != null);
            PsiElement parent = place.getParent();
            if (parent instanceof GrAssignmentExpression && ((GrAssignmentExpression)parent).getLValue() == place) {
                this.myHasWriteAccess = true;
            }
        }
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof GrBindingVariable && StringUtil.equals((CharSequence)this.getName(), (CharSequence)((GrBindingVariable)another).getName()) && this.getManager().areElementsEquivalent((PsiElement)this.getContainingFile(), (PsiElement)another.getContainingFile());
    }

    @Override
    public String toString() {
        return "Binding variable";
    }
}

