/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrVariableStubBase;

public class GrFieldStub
extends GrVariableStubBase<GrField> {
    public static final byte IS_PROPERTY = 1;
    public static final byte IS_ENUM_CONSTANT = 2;
    public static final byte IS_DEPRECATED_BY_DOC_TAG = 4;
    private final String[] myNamedParameters;
    private final byte myFlags;

    public GrFieldStub(StubElement parent, @Nullable StringRef name, @NotNull String[] annotations, @NotNull String[] namedParameters, @NotNull IStubElementType elemType, byte flags, @Nullable String typeText) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "<init>"));
        }
        if (namedParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedParameters", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "<init>"));
        }
        if (elemType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elemType", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "<init>"));
        }
        super(parent, elemType, name, annotations, typeText);
        this.myNamedParameters = namedParameters;
        this.myFlags = flags;
    }

    @NotNull
    public String[] getNamedParameters() {
        if (this.myNamedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFieldStub", "getNamedParameters"));
        }
        return this.myNamedParameters;
    }

    public boolean isProperty() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isDeprecatedByDocTag() {
        return (this.myFlags & 4) != 0;
    }

    public byte getFlags() {
        return this.myFlags;
    }

    public static byte buildFlags(GrField field) {
        byte f = 0;
        if (field instanceof GrEnumConstant) {
            f = (byte)(f | 2);
        }
        if (field.isProperty()) {
            f = (byte)(f | 1);
        }
        if (PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)field)) {
            f = (byte)(f | 4);
        }
        return f;
    }

    public static boolean isEnumConstant(byte flags) {
        return (flags & 2) != 0;
    }
}

