/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;

public class GrFileStub
extends PsiFileStubImpl<GroovyFile> {
    @NotNull
    private final String[] myAnnotations;
    private final StringRef myName;
    private final boolean isScript;

    public GrFileStub(GroovyFile file) {
        super((PsiFile)file);
        this.myName = StringRef.fromString((String)file.getViewProvider().getVirtualFile().getNameWithoutExtension());
        this.isScript = file.isScript();
        GrPackageDefinition definition = file.getPackageDefinition();
        this.myAnnotations = definition != null ? GrStubUtils.getAnnotationNames(definition) : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public GrFileStub(StringRef name, boolean isScript, @NotNull String[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub", "<init>"));
        }
        super(null);
        this.myName = name;
        this.isScript = isScript;
        this.myAnnotations = annotations;
    }

    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = GroovyParserDefinition.GROOVY_FILE;
        if (iStubFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub", "getType"));
        }
        return iStubFileElementType;
    }

    public StringRef getName() {
        return this.myName;
    }

    public boolean isScript() {
        return this.isScript;
    }

    @NotNull
    public String[] getAnnotations() {
        if (this.myAnnotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/GrFileStub", "getAnnotations"));
        }
        return this.myAnnotations;
    }
}

