/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.DelegatedMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrScopeProcessorWithHints;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;

public class DelegateTransformationSupport
implements AstTransformationSupport {
    private static final Set<String> OBJECT_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"equals", "hashCode", "getClass", "clone", "toString", "notify", "notifyAll", "wait", "finalize"});
    private static final Set<String> GROOVY_OBJECT_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"invokeMethod", "getProperty", "setProperty", "getMetaClass", "setMetaClass"});

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        PsiAnnotation annotation2;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport", "applyTransformation"));
        }
        LinkedHashMap declaredTypes = ContainerUtil.newLinkedHashMap();
        for (GrField field : context.getFields()) {
            annotation2 = PsiImplUtil.getAnnotation((PsiModifierListOwner)field, "groovy.lang.Delegate");
            if (annotation2 == null) continue;
            declaredTypes.putIfAbsent(field.getDeclaredType(), annotation2);
        }
        for (PsiMethod method : context.getMethods()) {
            annotation2 = PsiImplUtil.getAnnotation((PsiModifierListOwner)method, "groovy.lang.Delegate");
            if (annotation2 == null || method.getParameterList().getParametersCount() > 0) continue;
            declaredTypes.putIfAbsent(method.getReturnType(), annotation2);
        }
        declaredTypes.forEach((type, annotation) -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport", "lambda$applyTransformation$0"));
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClassType.ClassResolveResult delegateResult = ((PsiClassType)type).resolveGenerics();
            PsiClass delegate = delegateResult.getElement();
            if (delegate == null) {
                return;
            }
            DelegateProcessor processor = new DelegateProcessor(context, delegate, (PsiAnnotation)annotation);
            delegate.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)delegateResult.getSubstitutor()), null, (PsiElement)context.getCodeClass());
            if (!processor.myInterfaces) {
                return;
            }
            HashSet visited = ContainerUtil.newHashSet();
            LinkedList queue = ContainerUtil.newLinkedList((Object[])new Pair[]{Pair.create((Object)delegate, (Object)delegateResult.getSubstitutor())});
            while (!queue.isEmpty()) {
                Pair pair = (Pair)queue.poll();
                PsiClass currentClass = (PsiClass)pair.first;
                PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
                if (visited.add(currentClass) && currentClass.isInterface()) {
                    context.addInterface((PsiClassType)new PsiImmediateClassType(currentClass, substitutor));
                    continue;
                }
                for (PsiClassType superType : currentClass.getSuperTypes()) {
                    PsiClassType.ClassResolveResult resolveResult = superType.resolveGenerics();
                    PsiClass superClass = resolveResult.getElement();
                    if (superClass == null) continue;
                    queue.offer(Pair.create((Object)superClass, (Object)TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)currentClass, (PsiSubstitutor)substitutor)));
                }
            }
        });
    }

    private static boolean overridesObjectOrGroovyObject(PsiMethod method) {
        if (GroovyObjectTransformationSupport.isGroovyObjectSupportMethod(method)) {
            return true;
        }
        String name = method.getName();
        if (!OBJECT_METHODS.contains(name) && !GROOVY_OBJECT_METHODS.contains(name)) {
            return false;
        }
        PsiMethod superMethod = PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)method);
        if (superMethod == null) {
            return false;
        }
        PsiClass superClass = superMethod.getContainingClass();
        if (superClass == null) {
            return false;
        }
        String qname = superClass.getQualifiedName();
        return "java.lang.Object".equals(qname) || "groovy.lang.GroovyObject".equals(qname);
    }

    private static class DelegateProcessor
    extends GrScopeProcessorWithHints {
        private final TransformationContext myContext;
        private final boolean myInterfaces;
        private final boolean myDeprecated;
        private final boolean myKeepMethodAnnotations;
        private final boolean myKeepParameterAnnotations;
        private final Condition<PsiMethod> myIgnoreCondition;

        private DelegateProcessor(@NotNull TransformationContext context, @NotNull PsiClass delegate, @NotNull PsiAnnotation annotation) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "<init>"));
            }
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "<init>"));
            }
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "<init>"));
            }
            super(null, EnumSet.of(ElementClassHint.DeclarationKind.METHOD));
            this.myContext = context;
            this.myInterfaces = GrAnnotationUtil.inferBooleanAttributeNotNull(annotation, "interfaces");
            this.myDeprecated = this.myInterfaces && delegate.isInterface() || GrAnnotationUtil.inferBooleanAttributeNotNull(annotation, "deprecated");
            this.myKeepMethodAnnotations = GrAnnotationUtil.inferBooleanAttributeNotNull(annotation, "methodAnnotations");
            this.myKeepParameterAnnotations = GrAnnotationUtil.inferBooleanAttributeNotNull(annotation, "parameterAnnotations");
            this.myIgnoreCondition = this.buildCondition(annotation);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "execute"));
            }
            if (!(element instanceof PsiMethod)) {
                return true;
            }
            PsiMethod method = (PsiMethod)element;
            if (!this.myIgnoreCondition.value((Object)method)) {
                return true;
            }
            PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
            if (substitutor == null) {
                substitutor = PsiSubstitutor.EMPTY;
            }
            this.myContext.addMethod(this.createDelegationMethod(method, substitutor));
            return true;
        }

        @NotNull
        protected PsiMethod createDelegationMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
            boolean isRaw;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "createDelegationMethod"));
            }
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "createDelegationMethod"));
            }
            LightMethodBuilder builder = new LightMethodBuilder(this.myContext.getManager(), (Language)GroovyLanguage.INSTANCE, method.getName());
            builder.setMethodReturnType(substitutor.substitute(method.getReturnType()));
            builder.setContainingClass((PsiClass)this.myContext.getCodeClass());
            builder.setNavigationElement((PsiElement)method);
            builder.addModifier("public");
            PsiTypeParameter[] typeParameters = method.getTypeParameters();
            PsiClass containingClass = method.getContainingClass();
            boolean bl = isRaw = containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor);
            if (isRaw) {
                substitutor = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
            }
            if (!isRaw) {
                for (PsiTypeParameter typeParameter : typeParameters) {
                    builder.addTypeParameter(typeParameter);
                }
            }
            PsiParameter[] originalParameters = method.getParameterList().getParameters();
            for (int i = 0; i < originalParameters.length; ++i) {
                PsiParameter originalParameter = originalParameters[i];
                PsiType type = isRaw ? TypeConversionUtil.erasure((PsiType)substitutor.substitute(originalParameter.getType())) : substitutor.substitute(originalParameter.getType());
                if (type == null) {
                    type = TypesUtil.getJavaLangObject(this.myContext.getCodeClass());
                }
                LightParameter lightParameter = new LightParameter(StringUtil.notNullize((String)originalParameter.getName(), (String)("p" + i)), type, (PsiElement)builder, (Language)JavaLanguage.INSTANCE);
                if (this.myKeepParameterAnnotations) {
                    PsiCompositeModifierList delegatingModifierList = new PsiCompositeModifierList(method.getManager(), Collections.singletonList(originalParameter.getModifierList()));
                    lightParameter.setModifierList((LightModifierList)delegatingModifierList);
                }
                builder.addParameter((PsiParameter)lightParameter);
            }
            builder.setBaseIcon(JetgroovyIcons.Groovy.Method);
            DelegatedMethod delegatedMethod = new DelegatedMethod((PsiMethod)builder, method);
            if (delegatedMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "createDelegationMethod"));
            }
            return delegatedMethod;
        }

        @NotNull
        private Condition<PsiMethod> buildCondition(@NotNull PsiAnnotation annotation) {
            List<String> excludes;
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
            }
            Condition result = method -> {
                if (method.isConstructor() || method.hasModifierProperty("static")) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                String qname = containingClass.getQualifiedName();
                if ("java.lang.Object".equals(qname)) {
                    return false;
                }
                if ("groovy.lang.GroovyObject".equals(qname)) {
                    return false;
                }
                if ("groovy.lang.GroovyObjectSupport".equals(qname)) {
                    return false;
                }
                return !DelegateTransformationSupport.overridesObjectOrGroovyObject(method);
            };
            if (!this.myDeprecated) {
                result = Conditions.and((Condition)result, method -> PsiImplUtil.getAnnotation((PsiModifierListOwner)method, "java.lang.Deprecated") == null);
            }
            if (!(excludes = GrAnnotationUtil.getStringArrayValue(annotation, "excludes", true)).isEmpty()) {
                Condition condition = Conditions.and((Condition)result, method -> !excludes.contains(method.getName()));
                if (condition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
                }
                return condition;
            }
            List<String> includes = GrAnnotationUtil.getStringArrayValue(annotation, "includes", true);
            if (!includes.isEmpty()) {
                Condition condition = Conditions.and((Condition)result, method -> includes.contains(method.getName()));
                if (condition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
                }
                return condition;
            }
            List<PsiClass> excludeTypes = GrAnnotationUtil.getClassArrayValue(annotation, "excludeTypes", true);
            if (!excludeTypes.isEmpty()) {
                Condition condition = Conditions.and((Condition)result, method -> {
                    for (PsiClass excludeProvider : excludeTypes) {
                        if (excludeProvider.findMethodBySignature(method, false) == null) continue;
                        return false;
                    }
                    return true;
                });
                if (condition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
                }
                return condition;
            }
            List<PsiClass> includeTypes = GrAnnotationUtil.getClassArrayValue(annotation, "includeTypes", true);
            if (!includeTypes.isEmpty()) {
                Condition condition = Conditions.and((Condition)result, method -> {
                    for (PsiClass includeProvider : includeTypes) {
                        if (includeProvider.findMethodBySignature(method, false) == null) continue;
                        return true;
                    }
                    return false;
                });
                if (condition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
                }
                return condition;
            }
            Condition condition = result;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/transformations/impl/DelegateTransformationSupport$DelegateProcessor", "buildCondition"));
            }
            return condition;
        }
    }
}

