/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.ObjectKind;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlReferenceElementType
extends SqlCompositeElementType {
    private final ObjectKind myTargetKind;
    private final boolean myQualified;

    public static NotNullFunction<String, SqlReferenceElementType> factory(@NotNull ObjectKind targetType, boolean qualified) {
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/sql/psi/SqlReferenceElementType", "factory"));
        }
        return s -> {
            if (targetType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/sql/psi/SqlReferenceElementType", "lambda$factory$0"));
            }
            return new SqlReferenceElementType((String)s, targetType, qualified);
        };
    }

    public SqlReferenceElementType(@NotNull @NonNls String debugName, @NotNull ObjectKind targetKind, boolean qualified) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/SqlReferenceElementType", "<init>"));
        }
        if (targetKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetKind", "com/intellij/sql/psi/SqlReferenceElementType", "<init>"));
        }
        super(debugName);
        this.myTargetKind = targetKind;
        this.myQualified = qualified;
    }

    @NotNull
    public ObjectKind getTargetKind() {
        ObjectKind objectKind = this.myTargetKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/SqlReferenceElementType", "getTargetKind"));
        }
        return objectKind;
    }

    public boolean isQualified() {
        return this.myQualified;
    }
}

