/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTokenRegistry {
    private static final THashMap<String, SqlTokenType> ourTokensMap = SqlTokenRegistry.newTokenMap();
    private static final THashMap<Class, Map<String, SqlKeywordTokenType>> ourClassTokensMap = ContainerUtil.newTroveMap();
    private static final THashMap<String, IElementType> ourCompositeMap = ContainerUtil.newTroveMap();
    private static Consumer<String> ourTestInterceptor;

    private SqlTokenRegistry() {
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        SqlTokenType sqlTokenType = SqlTokenRegistry.getImpl(ourTokensMap, text, o -> Character.isLetter(o.charAt(0)) ? new SqlKeywordTokenType((String)o) : new SqlTokenType((String)o));
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text, @NotNull Function<String, ? extends SqlTokenType> factory) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        SqlTokenType sqlTokenType = SqlTokenRegistry.getImpl(ourTokensMap, text, factory);
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public static SqlCompositeElementType getCompositeType(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        SqlCompositeElementType sqlCompositeElementType = (SqlCompositeElementType)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, o -> new SqlCompositeElementType((String)o));
        if (sqlCompositeElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        return sqlCompositeElementType;
    }

    @NotNull
    public static <T extends IElementType> T getCompositeType(@NotNull String debugName, @NotNull Function<String, T> factory) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        IElementType iElementType = SqlTokenRegistry.getImpl(ourCompositeMap, debugName, factory);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        return (T)iElementType;
    }

    public static void setTestInterceptor(@NotNull Consumer<String> testInterceptor) {
        if (testInterceptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testInterceptor", "com/intellij/sql/util/SqlTokenRegistry", "setTestInterceptor"));
        }
        ourTestInterceptor = testInterceptor;
    }

    @NotNull
    private static synchronized <T extends IElementType> T getImpl(@NotNull Map<String, ? super T> map, @NotNull String debugName, @NotNull Function<String, T> factory) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/util/SqlTokenRegistry", "getImpl"));
        }
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/util/SqlTokenRegistry", "getImpl"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/util/SqlTokenRegistry", "getImpl"));
        }
        IElementType type = (IElementType)map.get(debugName);
        if (type == null) {
            type = (IElementType)ObjectUtils.notNull((Object)factory.fun((Object)debugName));
            map.put(debugName, type);
            if (ourTestInterceptor != null) {
                ourTestInterceptor.consume((Object)debugName);
            }
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getImpl"));
        }
        return (T)iElementType;
    }

    @Nullable
    public static synchronized SqlTokenType findTokenType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findTokenType"));
        }
        return (SqlTokenType)((Object)ourTokensMap.get((Object)text));
    }

    @Nullable
    public static synchronized IElementType findCompositeType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findCompositeType"));
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @Nullable
    public static synchronized IElementType findType(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findType"));
        }
        SqlTokenType token = (SqlTokenType)((Object)ourTokensMap.get((Object)text));
        if (token != null) {
            return token;
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @NotNull
    public static synchronized Iterable<IElementType> getAllCompositeTypes() {
        Collection collection = ourCompositeMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getAllCompositeTypes"));
        }
        return collection;
    }

    public static void initTypeMap(@NotNull Class clazz, @Nullable Set<String> exclude) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "initTypeMap"));
        }
        Map<String, SqlKeywordTokenType> map = SqlTokenRegistry.buildTokenMap(clazz, SqlTokenRegistry.newTokenMap());
        if (exclude != null) {
            map.keySet().removeAll(exclude);
        }
        SqlTokenRegistry.setTypeMap(clazz, map, false);
    }

    public static synchronized void addTokensToClassMap(@NotNull Class clazz, @NotNull Set<String> keywordSet) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "addTokensToClassMap"));
        }
        if (keywordSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordSet", "com/intellij/sql/util/SqlTokenRegistry", "addTokensToClassMap"));
        }
        Map existing = (Map)ourClassTokensMap.get((Object)clazz);
        Object map = existing == null ? SqlTokenRegistry.newTokenMap() : existing;
        for (String s : keywordSet) {
            if (map.containsKey(s)) continue;
            String upperCase = StringUtil.toUpperCase((String)s);
            map.put(upperCase, (SqlKeywordTokenType)SqlTokenRegistry.getType(upperCase));
        }
        SqlTokenRegistry.setTypeMap(clazz, map, true);
    }

    private static synchronized void setTypeMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map, boolean force) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "setTypeMap"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/util/SqlTokenRegistry", "setTypeMap"));
        }
        if (!force && ourClassTokensMap.containsKey((Object)clazz)) {
            return;
        }
        ourClassTokensMap.put((Object)clazz, map);
    }

    @NotNull
    public static NullableFunction<String, IElementType> getTokenProvider(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "getTokenProvider"));
        }
        NullableFunction nullableFunction = SqlTokenRegistry.getSafeMap(clazz)::get;
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getTokenProvider"));
        }
        return nullableFunction;
    }

    public static Set<String> getTokens(Class clazz) {
        return Collections.unmodifiableSet(SqlTokenRegistry.getSafeMap(clazz).keySet());
    }

    @NotNull
    private static synchronized Map<String, SqlKeywordTokenType> getSafeMap(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "getSafeMap"));
        }
        Map result = (Map)ourClassTokensMap.get((Object)clazz);
        if (result == null) {
            throw new AssertionError((Object)(clazz + " token map not initialized"));
        }
        Map map = result;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getSafeMap"));
        }
        return map;
    }

    private static <T extends IElementType> THashMap<String, T> newTokenMap() {
        return new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static Map<String, SqlKeywordTokenType> buildTokenMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "buildTokenMap"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/util/SqlTokenRegistry", "buildTokenMap"));
        }
        SqlTokenRegistry.consumeStaticFieldsInOrder(clazz, (PairConsumer<Field, Object>)((PairConsumer)(field, value) -> {
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/sql/util/SqlTokenRegistry", "lambda$buildTokenMap$2"));
            }
            if (value instanceof SqlKeywordTokenType) {
                SqlKeywordTokenType tokenType = (SqlKeywordTokenType)((Object)((Object)value));
                map.put(tokenType.toString(), tokenType);
            }
        }));
        return map;
    }

    public static void consumeStaticFieldsInOrder(@NotNull Class clazz, @NotNull PairConsumer<Field, Object> processor) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "consumeStaticFieldsInOrder"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/util/SqlTokenRegistry", "consumeStaticFieldsInOrder"));
        }
        JBIterable fields = ReflectionUtil.classTraverser((Class)clazz).postOrderDfsTraversal().flatMap(o -> JBIterable.of((Object[])o.getDeclaredFields())).filter(o -> Modifier.isStatic(o.getModifiers()));
        for (Field field : fields) {
            try {
                processor.consume((Object)field, field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static void ensureInterfacesAreInitializedInOrder(@NotNull Class<?> factoryClass) {
        if (factoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factoryClass", "com/intellij/sql/util/SqlTokenRegistry", "ensureInterfacesAreInitializedInOrder"));
        }
        JBIterable interfaces = ReflectionUtil.classTraverser(factoryClass).postOrderDfsTraversal().filter(o -> o.isInterface());
        for (Class aClass : interfaces) {
            Field[] fields = aClass.getDeclaredFields();
            if (fields.length == 0) continue;
            try {
                fields[0].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }
}

