/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inject.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.plugins.intelliLang.inject.JSLanguageInjectionSupport;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDontFormatCommentInjectionAction
extends JavaScriptIntention {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSDontFormatCommentInjectionAction", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inject.dont.format.intention.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSDontFormatCommentInjectionAction", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "JSDontFormatCommentInjectionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSDontFormatCommentInjectionAction", "isAvailable"));
        }
        Pair<JSInjection, PsiElement> pair = JSDontFormatCommentInjectionAction.getCommentInjection(editor, element);
        return pair != null && ((JSInjection)((Object)pair.first)).canReformat();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "JSDontFormatCommentInjectionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSDontFormatCommentInjectionAction", "invoke"));
        }
        Pair<JSInjection, PsiElement> pair = JSDontFormatCommentInjectionAction.getCommentInjection(editor, element);
        if (pair == null) {
            return;
        }
        JSInjection oldInjection = (JSInjection)((Object)pair.first);
        JSInjection newInjection = oldInjection.copy();
        newInjection.setCanReformat(false);
        ((PsiElement)pair.second).replace(JSDontFormatCommentInjectionAction.createCommentFromText(element, JSDontFormatCommentInjectionAction.getCommentText(oldInjection, element)));
        Configuration.getProjectInstance((Project)project).replaceInjectionsWithUndo(project, ContainerUtil.list((Object[])new JSInjection[]{newInjection}), ContainerUtil.list((Object[])new JSInjection[]{oldInjection}), ContainerUtil.list((Object[])new PsiElement[0]));
    }

    @NotNull
    private static String getCommentText(@NotNull JSInjection injection, @NotNull PsiElement context) {
        if (injection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "JSDontFormatCommentInjectionAction", "getCommentText"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "JSDontFormatCommentInjectionAction", "getCommentText"));
        }
        String commentPrefix = JSCodeStyleSettings.getLineCommentPrefix(context);
        StringBuilder builder = new StringBuilder("//" + commentPrefix + "language=" + injection.getInjectedLanguageId());
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" prefix=").append(injection.getPrefix());
        }
        if (!StringUtil.isEmpty((String)injection.getPrefix())) {
            builder.append(" suffix=").append(injection.getSuffix());
        }
        builder.append(" format=false");
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSDontFormatCommentInjectionAction", "getCommentText"));
        }
        return string;
    }

    @Nullable
    private static Pair<JSInjection, PsiElement> getCommentInjection(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSDontFormatCommentInjectionAction", "getCommentInjection"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost injectionHost = JSDontFormatCommentInjectionAction.getInjectionHost(element);
        PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)offset);
        if (injectedPsi == null || injectionHost == null || !JSFormattableInjectionUtil.hostContainsFormattableInjection((PsiElement)injectionHost)) {
            return null;
        }
        JSLanguageInjectionSupport injectionSupport = (JSLanguageInjectionSupport)((Object)ObjectUtils.tryCast((Object)injectedPsi.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT), JSLanguageInjectionSupport.class));
        if (injectionSupport == null) {
            return null;
        }
        Ref commentRef = new Ref();
        BaseInjection injection = injectionSupport.findCommentInjection((PsiElement)injectionHost, commentRef);
        if (injection != null && !commentRef.isNull()) {
            return Pair.create((Object)injection, (Object)commentRef.get());
        }
        return null;
    }

    @Nullable
    private static PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSDontFormatCommentInjectionAction", "getInjectionHost"));
        }
        PsiElement stringLiteral = element.getParent();
        return stringLiteral instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)stringLiteral : null;
    }

    @NotNull
    private static PsiElement createCommentFromText(@NotNull PsiElement element, String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSDontFormatCommentInjectionAction", "createCommentFromText"));
        }
        ASTNode node = JSChangeUtil.createJSTreeFromText(element.getProject(), text, DialectDetector.languageDialectOfElement(element));
        PsiElement psiElement = ((ASTNode)ObjectUtils.assertNotNull((Object)node)).getPsi(PsiComment.class);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSDontFormatCommentInjectionAction", "createCommentFromText"));
        }
        return psiElement;
    }
}

