/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.javascript.jest.JestConfigurationType;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfigurationProducer
extends JsTestRunConfigurationProducer<JestRunConfiguration> {
    public JestRunConfigurationProducer() {
        super((ConfigurationType)JestConfigurationType.getInstance(), JestUtil.RUNNER_PACKAGES);
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/jest/JestRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/jest/JestRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/javascript/jest/JestRunConfigurationProducer", "setupConfigurationFromCompatibleContext"));
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        if (!this.isTestRunnerPackageAvailableFor(element)) {
            return false;
        }
        TestElementInfo elementRunInfo = JestRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        JestRunSettings runSettings = elementRunInfo.getRunSettings();
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return true;
    }

    @Nullable
    private static JsTestElementPath createSuiteOrTestData(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createSuiteOrTestData"));
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TextRange textRange = element.getTextRange();
        if (jsFile == null || textRange == null) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        return jasmineStructure.findTestElementPath(textRange);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/jest/JestRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/jest/JestRunConfigurationProducer", "isConfigurationFromCompatibleContext"));
        }
        PsiElement element = context.getPsiLocation();
        if (element == null) {
            return false;
        }
        TestElementInfo elementRunInfo = JestRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        JestRunSettings thisRunSettings = elementRunInfo.getRunSettings();
        JestRunSettings thatRunSettings = configuration.getRunSettings();
        if (!thisRunSettings.getConfigFileSystemDependentPath().equals(thatRunSettings.getConfigFileSystemDependentPath())) {
            return false;
        }
        if (thisRunSettings.getScopeKind() != thatRunSettings.getScopeKind()) {
            return false;
        }
        JestScopeKind scopeKind = thisRunSettings.getScopeKind();
        if (scopeKind == JestScopeKind.ALL) {
            return true;
        }
        if (scopeKind == JestScopeKind.TEST_FILE) {
            return thisRunSettings.getTestFileSystemDependentPath().equals(thatRunSettings.getTestFileSystemDependentPath());
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return thisRunSettings.getTestFileSystemDependentPath().equals(thatRunSettings.getTestFileSystemDependentPath()) && thisRunSettings.getTestNames().equals(thatRunSettings.getTestNames());
        }
        return false;
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull JestRunSettings templateRunSettings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createTestElementRunInfo"));
        }
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createTestElementRunInfo"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        JsTestElementPath tep = JestRunConfigurationProducer.createSuiteOrTestData(element);
        if (StringUtil.isEmptyOrSpaces((String)templateRunSettings.getWorkingDirSystemDependentPath())) {
            String workingDir = JestRunConfigurationProducer.guessWorkingDir(element.getProject(), virtualFile);
            templateRunSettings = templateRunSettings.toBuilder().setWorkingDir(workingDir).build();
        }
        if (tep == null) {
            return JestRunConfigurationProducer.createFileInfo(element, virtualFile, templateRunSettings);
        }
        JestRunSettings.Builder builder = templateRunSettings.toBuilder();
        builder.setTestFilePath(virtualFile.getPath());
        String testName = tep.getTestName();
        if (testName == null) {
            builder.setScopeKind(JestScopeKind.SUITE);
            builder.setTestNames(tep.getSuiteNames());
        } else {
            builder.setScopeKind(JestScopeKind.TEST);
            ArrayList names = ContainerUtil.newArrayList((Iterable)tep.getSuiteNames());
            names.add(testName);
            builder.setTestNames(names);
        }
        return new TestElementInfo(builder.build(), (PsiElement)tep.getTestElement());
    }

    @NotNull
    private static String guessWorkingDir(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestRunConfigurationProducer", "guessWorkingDir"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/jest/JestRunConfigurationProducer", "guessWorkingDir"));
        }
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file);
        if (root == null) {
            root = project.getBaseDir();
        }
        String string = FileUtil.toSystemDependentName((String)root.getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationProducer", "guessWorkingDir"));
        }
        return string;
    }

    @Nullable
    private static TestElementInfo createFileInfo(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull JestRunSettings templateRunSettings) {
        JSTestFileType testFileType;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createFileInfo"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createFileInfo"));
        }
        if (templateRunSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateRunSettings", "com/intellij/javascript/jest/JestRunConfigurationProducer", "createFileInfo"));
        }
        JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        JSTestFileType jSTestFileType = testFileType = psiFile == null ? null : psiFile.getTestFileType();
        if (psiFile != null && testFileType != null) {
            JestRunSettings.Builder builder = templateRunSettings.toBuilder();
            builder.setScopeKind(JestScopeKind.TEST_FILE);
            builder.setTestFilePath(virtualFile.getPath());
            return new TestElementInfo(builder.build(), (PsiElement)psiFile);
        }
        JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JsonFile.class);
        if (jsonFile != null) {
            JsonProperty jestProp;
            if (JestUtil.isJestConfigFile(jsonFile.getName())) {
                JestRunSettings.Builder builder = templateRunSettings.toBuilder();
                builder.setConfigFilePath(virtualFile.getPath());
                VirtualFile parent = virtualFile.getParent();
                if (parent != null) {
                    builder.setWorkingDir(parent.getPath());
                }
                builder.setScopeKind(JestScopeKind.ALL);
                return new TestElementInfo(builder.build(), (PsiElement)jsonFile);
            }
            if (PackageJsonUtil.isPackageJsonFile((PsiFile)jsonFile) && (jestProp = PackageJsonUtil.findContainingTopLevelProperty(element)) != null && "jest".equals(jestProp.getName())) {
                JestRunSettings.Builder builder = templateRunSettings.toBuilder();
                VirtualFile parent = virtualFile.getParent();
                if (parent != null) {
                    builder.setWorkingDir(parent.getPath());
                }
                builder.setScopeKind(JestScopeKind.ALL);
                return new TestElementInfo(builder.build(), (PsiElement)jestProp);
            }
        }
        return null;
    }

    private static class TestElementInfo {
        private final JestRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        public TestElementInfo(@NotNull JestRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo", "<init>"));
            }
            if (enclosingTestElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enclosingTestElement", "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo", "<init>"));
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public JestRunSettings getRunSettings() {
            JestRunSettings jestRunSettings = this.myRunSettings;
            if (jestRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo", "getRunSettings"));
            }
            return jestRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo", "getEnclosingTestElement"));
            }
            return psiElement;
        }
    }
}

