/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeInterpretersView;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeUIUtil {
    public static final String NODE_INTERPRETER_LABEL = "Node interpreter:";
    public static final String NODE_INTERPRETER_LABEL_WITH_MNEMONIC = "&Node interpreter:";
    public static final String NODE_INTERPRETER_LABEL_WITH_MNEMONIC_ESC = "\u001bNode interpreter:";

    private NodeUIUtil() {
    }

    @NotNull
    public static ReadonlyFieldWithHistoryWithBrowseButton createNodeInterpreterTextField(@Nullable Project project) {
        ReadonlyFieldWithHistoryWithBrowseButton readonlyFieldWithHistoryWithBrowseButton = NodeUIUtil.createNodeInterpreterTextField(project, false);
        if (readonlyFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeUIUtil", "createNodeInterpreterTextField"));
        }
        return readonlyFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static ReadonlyFieldWithHistoryWithBrowseButton createNodeInterpreterTextField(@Nullable Project project, boolean withRemote) {
        final ReadonlyFieldWithHistoryWithBrowseButton field = new ReadonlyFieldWithHistoryWithBrowseButton.Builder().withActionListener((event, initialValue) -> {
            Pair<String, SemVer> pair = NodeInterpretersView.configureAndSelect(project, withRemote, initialValue);
            if (pair != null) {
                return (String)pair.getFirst();
            }
            return null;
        }).withHistoryProvider(() -> withRemote ? NodeDetectionUtil.listAllPossibleNodeInterpretersWithRemote() : NodeDetectionUtil.listAllPossibleNodeInterpretersPaths()).withRenderer(textFieldWithHistory -> {
            NodeVersionsListCellRenderer popupListCellRenderer = new NodeVersionsListCellRenderer((TextFieldWithHistory)textFieldWithHistory);
            return new DelegatingCellRenderer(textFieldWithHistory.getRenderer(), (ListCellRenderer)((Object)popupListCellRenderer));
        }).build();
        ReadonlyFieldWithHistoryWithBrowseButton readonlyFieldWithHistoryWithBrowseButton = new ReadonlyFieldWithHistoryWithBrowseButton(){

            public JComponent getComponent() {
                return field.getComponent();
            }

            public void set(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/javascript/nodejs/NodeUIUtil$1", "set"));
                }
                if (!NodeLocalVersionsManager.isRemote(text)) {
                    text = FileUtil.toSystemDependentName((String)text);
                }
                field.set(text);
            }

            @NotNull
            public String get() {
                String string = field.get();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeUIUtil$1", "get"));
                }
                return string;
            }

            public void addListener(Runnable listener) {
                field.addListener(listener);
            }

            public void setPreferredWidthToFitText() {
                field.setPreferredWidthToFitText();
            }
        };
        if (readonlyFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeUIUtil", "createNodeInterpreterTextField"));
        }
        return readonlyFieldWithHistoryWithBrowseButton;
    }

    public static JPanel wrapInCenteredPanel(String text) {
        JBLabel comp = new JBLabel(text);
        comp.setForeground(UIUtil.getInactiveTextColor());
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 0));
        listPane.add(Box.createHorizontalGlue());
        listPane.add((Component)comp);
        listPane.setBackground(UIUtil.getTableBackground());
        listPane.add(Box.createHorizontalGlue());
        return listPane;
    }

    public static void balloonInfo(@NotNull Project project, @NotNull String message, @Nullable Point onScreen, @Nullable MessageType messageType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeUIUtil", "balloonInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/javascript/nodejs/NodeUIUtil", "balloonInfo"));
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeUIUtil", "lambda$balloonInfo$3"));
                }
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/javascript/nodejs/NodeUIUtil", "lambda$balloonInfo$3"));
                }
                NodeUIUtil.balloonInfo(project, message, onScreen, messageType);
            }, ModalityState.any());
            return;
        }
        Balloon balloon = NodeUIUtil.createMessageBalloon(message, messageType, project);
        if (onScreen != null) {
            balloon.show(new RelativePoint(onScreen), Balloon.Position.below);
        } else {
            IdeFrameImpl frame = WindowManagerEx.getInstanceEx().getFrame(project);
            balloon.show(new RelativePoint((Component)frame, new Point(frame.getWidth() - 20, 20)), Balloon.Position.atRight);
        }
    }

    @NotNull
    private static Balloon createMessageBalloon(@NotNull String message, MessageType messageType, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/javascript/nodejs/NodeUIUtil", "createMessageBalloon"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeUIUtil", "createMessageBalloon"));
        }
        messageType = messageType == null ? MessageType.INFO : messageType;
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, messageType.getDefaultIcon(), messageType.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(TimeUnit.SECONDS.toMillis(3L));
        Balloon balloon = balloonBuilder.createBalloon();
        Disposer.register((Disposable)project, (Disposable)balloon);
        Balloon balloon2 = balloon;
        if (balloon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeUIUtil", "createMessageBalloon"));
        }
        return balloon2;
    }

    private static class NodeVersionsListCellRenderer
    extends ColoredListCellRenderer<String> {
        private final TextFieldWithHistory myHistory;
        private final NodeJSRemoteInterpreterManager myRemoteInterpreterManager;
        private int myHistoryPreferredSize;
        private Integer myMaxTextWidth;
        private FontMetrics myMetrics;
        private final NodeLocalVersionsManager myVersionsManager;

        private NodeVersionsListCellRenderer(@NotNull TextFieldWithHistory history) {
            if (history == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/javascript/nodejs/NodeUIUtil$NodeVersionsListCellRenderer", "<init>"));
            }
            this.myHistoryPreferredSize = -1;
            this.myVersionsManager = NodeLocalVersionsManager.getInstance();
            this.myRemoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();
            this.myHistory = history;
        }

        protected void customizeCellRenderer(@NotNull JList list, String value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/NodeUIUtil$NodeVersionsListCellRenderer", "customizeCellRenderer"));
            }
            if (index == 0 || this.myMetrics == null) {
                this.calculateMaxWidth();
            }
            if (value != null) {
                this.append(value, SimpleTextAttributes.REGULAR_ATTRIBUTES, 0, 2);
                String versionText = this.versionText(value);
                if (versionText != null) {
                    int versionWidth = this.myMetrics.stringWidth("  " + versionText);
                    int versionEnd = Math.max(versionWidth + this.myMaxTextWidth, this.myHistory.getTextEditor().getWidth());
                    this.append(versionText, SimpleTextAttributes.GRAY_ATTRIBUTES, versionEnd, 4);
                    this.updatePopupWidth(versionEnd + JBUI.scale((int)6));
                }
            }
        }

        private void updatePopupWidth(int popupWidth) {
            if (this.myHistoryPreferredSize < popupWidth && this.myHistory.getSize().width < popupWidth) {
                this.myHistoryPreferredSize = popupWidth;
                SwingHelper.setPreferredWidth((Component)this.myHistory, (int)popupWidth);
            }
        }

        @Nullable
        private String versionText(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/nodejs/NodeUIUtil$NodeVersionsListCellRenderer", "versionText"));
            }
            if (NodeLocalVersionsManager.isRemote(path) && this.myRemoteInterpreterManager != null) {
                return this.myRemoteInterpreterManager.getNodeVersionCached(path).getRawVersion();
            }
            SemVer version = this.myVersionsManager.getVersion(path);
            return version != null ? version.getRawVersion() : null;
        }

        private void calculateMaxWidth() {
            this.myMetrics = this.getFontMetrics(this.getFont());
            int max = 0;
            for (String line : this.myHistory.getHistory()) {
                max = Math.max(max, this.myMetrics.stringWidth(line));
            }
            this.myMaxTextWidth = max;
        }
    }

    private static class DelegatingCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer myOriginalCellRenderer;
        private final ListCellRenderer myPopupCellRenderer;

        public DelegatingCellRenderer(@NotNull ListCellRenderer originalCellRenderer, @NotNull ListCellRenderer popupCellRenderer) {
            if (originalCellRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalCellRenderer", "com/intellij/javascript/nodejs/NodeUIUtil$DelegatingCellRenderer", "<init>"));
            }
            if (popupCellRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupCellRenderer", "com/intellij/javascript/nodejs/NodeUIUtil$DelegatingCellRenderer", "<init>"));
            }
            this.myOriginalCellRenderer = originalCellRenderer;
            this.myPopupCellRenderer = popupCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListCellRenderer cellRenderer = index == -1 ? this.myOriginalCellRenderer : this.myPopupCellRenderer;
            return cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

