/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesPredefinedLibraryProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(NodeModulesPredefinedLibraryProvider.class);
    private static final Set<String> EXCLUDED_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"test", "tests", "spec", "specs", "node_modules"});
    public static final String TYPESCRIPT_DEPENDENCY = "typescript";

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List<NodeModulesLibraryDirectory> nodeModulesDirs = manager.getNodeModulesDirectories();
        List models = ContainerUtil.mapNotNull(nodeModulesDirs, nodeModulesDir -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "lambda$getPredefinedLibraries$0"));
            }
            return NodeModulesPredefinedLibraryProvider.createLibraryModel(project, nodeModulesDir);
        });
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryModel.toArray((Collection)models);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @Nullable
    private static ScriptingLibraryModel createLibraryModel(@NotNull Project project, @NotNull NodeModulesLibraryDirectory libraryDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "createLibraryModel"));
        }
        if (libraryDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "createLibraryModel"));
        }
        if (!libraryDir.getNodeModulesDir().isValid()) {
            LOG.warn("Cannot create library as " + libraryDir.getNodeModulesDir().getPath() + " is invalid");
            return null;
        }
        if (libraryDir.isForApplicationSourceCode()) {
            return null;
        }
        NodeModulesLibraryModel libraryModel = new NodeModulesLibraryModel(libraryDir, project);
        libraryDir.setLibraryModel(libraryModel);
        return libraryModel;
    }

    @NotNull
    private static List<VirtualFile> getRootsInsideNodeModules(@NotNull Project project, @NotNull VirtualFile nodeModulesDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getRootsInsideNodeModules"));
        }
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getRootsInsideNodeModules"));
        }
        if (!nodeModulesDir.isValid()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getRootsInsideNodeModules"));
            }
            return list;
        }
        ArrayList rootsToIndex = ContainerUtil.newArrayList();
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonData data = (PackageJsonData)ProjectLocator.computeWithPreferredProject((VirtualFile)packageJson, (Project)project, () -> PackageJsonUtil.getOrCreateData(packageJson));
            Set<String> dependencies = data.getAllDependencies();
            for (String dependency : dependencies) {
                VirtualFile dir;
                if (!NodeModulesPredefinedLibraryProvider.isDependencyIndexed(data, dependency) || (dir = nodeModulesDir.findFileByRelativePath(dependency)) == null || !dir.isValid() || !dir.isDirectory()) continue;
                NodeModulesPredefinedLibraryProvider.collectDependencyRoots(rootsToIndex, dir);
            }
            VirtualFile types = nodeModulesDir.findChild("@types");
            if (types != null && types.isValid() && types.isDirectory()) {
                rootsToIndex.add(types);
            }
            NodeModulesDirectoryManager.getInstance(project).setProvidedPackageJsonRoots(packageJson, data);
        } else {
            VirtualFile[] children;
            for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)nodeModulesDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                String name = child.getName();
                if (name.startsWith(".") || name.startsWith("_")) continue;
                NodeModulesPredefinedLibraryProvider.collectDependencyRoots(rootsToIndex, child);
            }
        }
        ArrayList arrayList = rootsToIndex;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getRootsInsideNodeModules"));
        }
        return arrayList;
    }

    public static boolean isDependencyIndexed(@NotNull PackageJsonData data, @NotNull String dependencyName) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "isDependencyIndexed"));
        }
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "isDependencyIndexed"));
        }
        if (TYPESCRIPT_DEPENDENCY.equals(dependencyName)) {
            return data.isDependencyOfAnyTypeExcludeDev(dependencyName);
        }
        return data.isDependencyOfAnyType(dependencyName);
    }

    public static boolean isDependencyChildIncluded(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "isDependencyChildIncluded"));
        }
        String name = fileOrDir.getName();
        return !StringUtil.startsWith((CharSequence)name, (CharSequence)".") && !EXCLUDED_NAMES.contains(name);
    }

    private static void collectDependencyRoots(@NotNull List<VirtualFile> roots, @NotNull VirtualFile dependency) {
        VirtualFile[] children;
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "collectDependencyRoots"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "collectDependencyRoots"));
        }
        for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)dependency.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
            if (!NodeModulesPredefinedLibraryProvider.isDependencyChildIncluded(child)) continue;
            roots.add(child);
        }
    }

    private static class NodeModulesLibraryModel
    extends ScriptingLibraryModel {
        private final Project myProject;
        private final VirtualFile myNodeModulesDir;
        private final AtomicInteger myCalcRootsCount;
        private final VolatileNotNullLazyValue<Set<VirtualFile>> myRoots;

        public NodeModulesLibraryModel(@NotNull NodeModulesLibraryDirectory libraryDir, @NotNull Project project) {
            if (libraryDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "<init>"));
            }
            super(libraryDir.getLibraryName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PREDEFINED, false);
            this.myCalcRootsCount = new AtomicInteger(0);
            this.myRoots = new VolatileNotNullLazyValue<Set<VirtualFile>>(){

                @NotNull
                protected Set<VirtualFile> compute() {
                    int calcRootsCount = myCalcRootsCount.incrementAndGet();
                    if (calcRootsCount > 1) {
                        LOG.warn("Concurrent node_modules roots calculation: " + calcRootsCount);
                    }
                    Set set = this.calcRoots();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel$1", "compute"));
                    }
                    return set;
                }
            };
            this.myProject = project;
            this.myNodeModulesDir = libraryDir.getNodeModulesDir();
        }

        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            Set set = (Set)this.myRoots.getValue();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "getSourceFiles"));
            }
            return set;
        }

        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "collectFilesWithGlobalDefinitions"));
            }
        }

        public boolean shouldIndexSourcesWithoutMappings() {
            return false;
        }

        @NotNull
        public List<VirtualFile> getDefaultMappings() {
            List<VirtualFile> list = Collections.singletonList(this.myNodeModulesDir.getParent());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "getDefaultMappings"));
            }
            return list;
        }

        @NotNull
        private Set<VirtualFile> calcRoots() {
            JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
            if (libraryMappings.getMappingsByLibraryName(this.getName()).isEmpty()) {
                Set<VirtualFile> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "calcRoots"));
                }
                return set;
            }
            List roots = NodeModulesPredefinedLibraryProvider.getRootsInsideNodeModules(this.myProject, this.myNodeModulesDir);
            HashSet hashSet = ContainerUtil.newHashSet((Iterable)roots);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "calcRoots"));
            }
            return hashSet;
        }
    }
}

