/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class NodeModulesRequestMerger {
    private final Alarm myAlarm;
    private final long myMergeDelayMillis;
    private final Runnable myRequestHandler;

    /*
     * WARNING - void declaration
     */
    public NodeModulesRequestMerger(@NotNull Project project, @NotNull Alarm.ThreadToUse requestHandlerThreadToUse, long mergeDelayMillis, @NotNull Runnable runnable) {
        void requestHandler;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesRequestMerger", "<init>"));
        }
        if (requestHandlerThreadToUse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestHandlerThreadToUse", "com/intellij/javascript/nodejs/library/NodeModulesRequestMerger", "<init>"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestHandler", "com/intellij/javascript/nodejs/library/NodeModulesRequestMerger", "<init>"));
        }
        this.myAlarm = new Alarm(requestHandlerThreadToUse, (Disposable)project);
        this.myMergeDelayMillis = mergeDelayMillis;
        this.myRequestHandler = requestHandler;
    }

    public void request() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myRequestHandler.run();
        } else {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(this.myRequestHandler, this.myMergeDelayMillis);
        }
    }
}

