/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeModulesSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    private static final Logger LOG = Logger.getInstance(NodeModulesSyntheticLibraryProvider.class);

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "getAdditionalProjectLibraries"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List libraries = (List)manager.computeFileIndexExtensionPreventingRecursion(() -> NodeModulesSyntheticLibraryProvider.computeRoots(manager));
        List list = ContainerUtil.notNullize((List)libraries);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "getAdditionalProjectLibraries"));
        }
        return list;
    }

    @NotNull
    private static List<SyntheticLibrary> computeRoots(@NotNull NodeModulesDirectoryManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "computeRoots"));
        }
        List<NodeModulesLibraryDirectory> libraryDirs = manager.getNodeModulesDirectories();
        List list = ContainerUtil.mapNotNull(libraryDirs, libraryDir -> {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "lambda$computeRoots$1"));
            }
            if (!manager.isLibraryWithMappings((NodeModulesLibraryDirectory)libraryDir)) {
                return null;
            }
            ScriptingLibraryModel libraryModel = libraryDir.getLibraryModel();
            if (libraryModel == null) {
                LOG.warn("No preloaded library for " + libraryDir.getNodeModulesDir().getPath());
                return null;
            }
            return new NodeModulesSyntheticLibrary(libraryModel);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider", "computeRoots"));
        }
        return list;
    }

    private static class NodeModulesSyntheticLibrary
    extends SyntheticLibrary {
        private final List<VirtualFile> mySourceRoots;

        public NodeModulesSyntheticLibrary(@NotNull ScriptingLibraryModel libraryModel) {
            if (libraryModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryModel", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider$NodeModulesSyntheticLibrary", "<init>"));
            }
            this.mySourceRoots = ContainerUtil.filter((Collection)libraryModel.getSourceFiles(), VirtualFile::isValid);
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            List<VirtualFile> list = this.mySourceRoots;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesSyntheticLibraryProvider$NodeModulesSyntheticLibrary", "getSourceRoots"));
            }
            return list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeModulesSyntheticLibrary library = (NodeModulesSyntheticLibrary)((Object)o);
            return this.mySourceRoots.equals(library.mySourceRoots);
        }

        public int hashCode() {
            return this.mySourceRoots.hashCode();
        }
    }
}

