/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MemberAccessCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != null) {
            return;
        }
        JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class);
        if (parentFunction == null) {
            return;
        }
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction);
        if (containingClass == null || DialectDetector.isActionScript((PsiElement)containingClass)) {
            return;
        }
        final HashMap forCompletion = ContainerUtil.newHashMap();
        final HashMap typeSubstitutors = ContainerUtil.newHashMap();
        TypeScriptUtil.JSClassHierarchyProcessor processor = new TypeScriptUtil.JSClassHierarchyProcessor(){

            @Override
            public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements) {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor$1", "process"));
                }
                if (typeSubstitutor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSubstitutor", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor$1", "process"));
                }
                for (JSElement element : aClass.getMembers()) {
                    String name;
                    JSAttributeList.AccessType type;
                    if (!(element instanceof JSElementBase) || (type = ((JSElementBase)element).getAccessType()) == JSAttributeList.AccessType.PRIVATE && !aClass.isEquivalentTo((PsiElement)containingClass) || StringUtil.isEmpty((String)(name = element.getName())) || forCompletion.containsKey(name)) continue;
                    forCompletion.put(name, element);
                }
                typeSubstitutors.put(aClass, typeSubstitutor);
                return true;
            }
        };
        JSClassUtils.processClassesInHierarchy(containingClass, true, processor);
        forCompletion.values().forEach(el -> {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6MemberAccessCompletionContributor", "lambda$fillCompletionVariants$0"));
            }
            LookupElement element = ES6MemberAccessCompletionContributor.createLookupElement(el);
            if (element != null) {
                result.consume(element);
            }
        });
    }

    @Nullable
    private static LookupElement createLookupElement(JSElement el) {
        String name = el.getName();
        assert (name != null);
        LookupElementBuilder baseElement = JSLookupUtilImpl.createLookupElement((PsiElement)el, name);
        return PrioritizedLookupElement.withPriority((LookupElement)baseElement.withInsertHandler((handleInsert, item) -> {
            handleInsert.getDocument().insertString(handleInsert.getStartOffset(), (CharSequence)"this.");
            JSInsertHandler.insertBracesIfNeed(handleInsert, (PsiElement)el, null);
        }), (double)JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY.getPriorityValue());
    }
}

