/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.findUsages.JSFindReferencesResultProcessor;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6ExportDefaultReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6ExportDefaultReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof JSElement)) {
            return;
        }
        PsiElement exportElement = null;
        if (element instanceof ES6ExportDefaultAssignment || ES6ExportDefaultReferenceSearcher.isDefaultExportThroughSpecifier(element)) {
            exportElement = element;
        } else {
            PsiElement parent = element.getContext();
            if (parent instanceof ES6ExportDefaultAssignment) {
                exportElement = parent;
            }
        }
        if (exportElement != null) {
            ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(queryParameters, consumer, exportElement);
        } else {
            if (!(element instanceof JSPsiNamedElementBase)) {
                return;
            }
            DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
            if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
                return;
            }
            String name = ((JSPsiNamedElementBase)element).getName();
            if (name != null) {
                SearchRequestCollector collector = queryParameters.getOptimizer();
                collector.searchWord(name, queryParameters.getEffectiveSearchScope(), (short)1, true, element, (RequestResultProcessor)new MyProcessor(element, queryParameters, consumer));
            }
        }
    }

    private static boolean isDefaultExportThroughSpecifier(PsiElement element) {
        if (!(element instanceof ES6ExportSpecifier)) {
            return false;
        }
        ES6ExportSpecifierAlias alias = ((ES6ExportSpecifier)element).getAlias();
        return alias != null && "default".equals(alias.getName());
    }

    protected static void searchExportDefaultUsages(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull PsiElement element) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher", "searchExportDefaultUsages"));
        }
        JSElement container = ES6PsiUtil.getExportScope(element);
        if (container == null && (container = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{XmlFile.class})) == null) {
            return;
        }
        Collection fileReferences = ReferencesSearch.search((PsiElement)container).findAll();
        if (fileReferences.isEmpty()) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        for (PsiReference fileReference : fileReferences) {
            ES6ImportedBinding[] importedBindings;
            PsiElement importDeclaration;
            PsiElement fileReferenceElement = fileReference.getElement();
            if (!(fileReferenceElement instanceof ES6FromClause) || !((importDeclaration = fileReferenceElement.getParent()) instanceof ES6ImportDeclaration)) continue;
            for (ES6ImportedBinding importedBinding : importedBindings = ((ES6ImportDeclaration)importDeclaration).getImportedBindings()) {
                if (importedBinding.isNamespaceImport()) continue;
                ReferencesSearch.search((PsiElement)importedBinding, (SearchScope)scope.intersectWith(importedBinding.getUseScope())).forEach(consumer);
            }
        }
    }

    private static class MyProcessor
    extends JSFindReferencesResultProcessor {
        private final Processor<PsiReference> myConsumer;

        MyProcessor(PsiElement target, ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer) {
            super(target, queryParameters);
            this.myConsumer = consumer;
        }

        @Override
        protected boolean proceedWithReference(@NotNull PsiElement element, SearchRequestCollector collector) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher$MyProcessor", "proceedWithReference"));
            }
            if (!(element instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(this.myQueryParameters, this.myConsumer, parent);
                return true;
            }
            return false;
        }
    }
}

