/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ImportES6ModuleFix;
import com.intellij.lang.javascript.modules.JSSimpleModuleReferenceInfo;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.completion.ES6ImportCompletionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportPsiUtil {
    public static final String DEFAULT = "default";
    public static final TokenSet ES6_IMPORT_DECLARATION = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION});
    public static final TokenSet IMPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT, ES6ElementTypes.IMPORT_DECLARATION});

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromText(PsiElement[] declarations, @NotNull String moduleName, boolean checkAcceptable) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findExistingES6ImportByFromText"));
        }
        String unquotedModule = StringUtil.unquoteString((String)moduleName);
        if (!unquotedModule.isEmpty()) {
            for (PsiElement declaration : declarations) {
                String fromText;
                if (!(declaration instanceof ES6ImportDeclaration) || !unquotedModule.equals(fromText = ES6ImportPsiUtil.getUnquotedFromClauseOrModuleText((ES6ImportExportDeclaration)((ES6ImportDeclaration)declaration))) || checkAcceptable && !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
                return (ES6ImportDeclaration)declaration;
            }
        }
        return null;
    }

    public static boolean isAcceptableAsExistingImport(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "isAcceptableAsExistingImport"));
        }
        if (declaration.getImportSpecifiers().length > 0) {
            return true;
        }
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        if (bindings.length != 1) {
            return bindings.length == 0;
        }
        ES6ImportedBinding binding = bindings[0];
        return !binding.isNamespaceImport();
    }

    public static boolean tryToAddImportToExistingDeclaration(@NotNull ES6ImportDeclaration declaration, @NotNull String name, @NotNull ImportExportType type) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "tryToAddImportToExistingDeclaration"));
        }
        if (type == ImportExportType.BARE) {
            return true;
        }
        CreateImportExportInfo info = new CreateImportExportInfo(name, type);
        return ES6ImportPsiUtil.insertImportSpecifier(declaration, info) != null;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findPlaceForImport(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findPlaceForImport"));
        }
        Pair<Boolean, PsiElement> pair = ES6ImportPsiUtil.findAnchorToInsert(scope, IMPORT_ELEMENT_TYPES, true);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findPlaceForImport"));
        }
        return pair;
    }

    @NotNull
    public static Pair<Boolean, PsiElement> findAnchorToInsert(@NotNull PsiElement scope, TokenSet elementTypesToSkip, boolean first) {
        PsiElement place;
        ASTNode lBrace;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findAnchorToInsert"));
        }
        PsiElement currentChild = scope.getFirstChild();
        if (scope instanceof TypeScriptModule && (lBrace = scope.getNode().findChildByType(JSTokenTypes.LBRACE)) != null) {
            currentChild = lBrace.getPsi().getNextSibling();
        }
        PsiElement lastElement = null;
        while (currentChild != null) {
            if (elementTypesToSkip.contains(currentChild.getNode().getElementType()) || JSPsiImplUtils.isUseStrictStatement(currentChild)) {
                lastElement = currentChild;
            } else if (lastElement == null && !(currentChild instanceof PsiWhiteSpace) && !(currentChild instanceof PsiComment)) break;
            currentChild = currentChild.getNextSibling();
        }
        if ((place = lastElement) == null) {
            if (!first) {
                ASTNode rBrace;
                place = scope.getLastChild();
                if (scope instanceof TypeScriptModule && (rBrace = scope.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
                    place = rBrace.getPsi().getPrevSibling();
                }
                Pair pair = Pair.create((Object)true, (Object)place);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findAnchorToInsert"));
                }
                return pair;
            }
            place = currentChild;
        }
        Pair pair = Pair.create((Object)(lastElement != null ? 1 : 0), (Object)place);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findAnchorToInsert"));
        }
        return pair;
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6Import(@NotNull PsiElement placeModule, @Nullable PsiElement module, @NotNull String moduleName, boolean anyImport) {
        if (placeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeModule", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findExistingES6Import"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findExistingES6Import"));
        }
        PsiElement[] declarations = JSResolveUtil.getStubbedChildren(placeModule, ES6_IMPORT_DECLARATION);
        if (declarations.length == 0) {
            return null;
        }
        ES6ImportDeclaration result = ES6ImportPsiUtil.findExistingES6ImportByFromText(declarations, moduleName, anyImport);
        if (result != null) {
            return result;
        }
        return ES6ImportPsiUtil.findExistingES6ImportByFromModules(declarations, module, anyImport);
    }

    @Nullable
    public static ES6ImportDeclaration findExistingES6ImportByFromModules(@NotNull PsiElement[] declarations, @Nullable PsiElement module, boolean checkAcceptable) {
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findExistingES6ImportByFromModules"));
        }
        if (module == null) {
            return null;
        }
        for (PsiElement declaration : declarations) {
            Collection resolvedElements;
            ES6ImportDeclaration es6Import;
            ES6FromClause clause;
            if (!(declaration instanceof ES6ImportDeclaration) || (clause = (es6Import = (ES6ImportDeclaration)declaration).getFromClause()) == null || !(resolvedElements = clause.resolveReferencedElements()).contains(module) || checkAcceptable && !ES6ImportPsiUtil.isAcceptableAsExistingImport((ES6ImportDeclaration)declaration)) continue;
            return es6Import;
        }
        return null;
    }

    public static String getExportedElementName(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getExportedElementName"));
        }
        if (element instanceof JSExportAssignment) {
            String fileName = element.getContainingFile().getName();
            return JSFileReference.getFileNameWithoutExtension(fileName, JSFileReference.IMPLICIT_EXTENSIONS);
        }
        return element.getName();
    }

    @NotNull
    public static String wrapWithQuotesFromSettings(String externalModuleName, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "wrapWithQuotesFromSettings"));
        }
        String quote = JSCodeStyleSettings.getQuote(context);
        String string = externalModuleName = quote + externalModuleName + quote;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "wrapWithQuotesFromSettings"));
        }
        return string;
    }

    @NotNull
    public static Collection<ES6ImportDeclaration> getImportDeclarations(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getImportDeclarations"));
        }
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)scope, ES6ImportDeclaration.class);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getImportDeclarations"));
        }
        return collection;
    }

    @NotNull
    public static ES6ExistingImports getExistingImports(@NotNull PsiElement scope, @NotNull String fromReferenceText) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getExistingImports"));
        }
        if (fromReferenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromReferenceText", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getExistingImports"));
        }
        Collection<ES6ImportDeclaration> elements = ES6ImportPsiUtil.getImportDeclarations(scope);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (ES6ImportDeclaration declaration : elements) {
            String quotedFromClauseText = ES6ImportPsiUtil.getFromClauseText((ES6ImportExportDeclaration)declaration);
            if (quotedFromClauseText == null || !fromReferenceText.equals(StringUtil.unquoteString((String)quotedFromClauseText))) continue;
            result.add(declaration);
        }
        ES6ExistingImports eS6ExistingImports = new ES6ExistingImports(result);
        if (eS6ExistingImports == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getExistingImports"));
        }
        return eS6ExistingImports;
    }

    @Nullable
    public static String getFromClauseText(@Nullable ES6ImportExportDeclaration declaration) {
        ES6FromClause clause;
        ES6FromClause eS6FromClause = clause = declaration == null ? null : declaration.getFromClause();
        if (clause == null) {
            return null;
        }
        return StringUtil.nullize((String)clause.getReferenceText());
    }

    @Nullable
    public static String getUnquotedFromClauseOrModuleText(@NotNull ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getUnquotedFromClauseOrModuleText"));
        }
        String text = ES6ImportPsiUtil.getUnquotedFromClauseText(declaration);
        if (text != null) {
            return text;
        }
        String moduleText = declaration instanceof ES6ImportDeclaration ? ((ES6ImportDeclaration)declaration).getImportModuleText() : null;
        return moduleText == null ? null : StringUtil.unquoteString((String)moduleText);
    }

    @Nullable
    public static String getUnquotedFromClauseText(@NotNull ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getUnquotedFromClauseText"));
        }
        String fromClauseText = ES6ImportPsiUtil.getFromClauseText(declaration);
        return fromClauseText == null ? null : StringUtil.unquoteString((String)fromClauseText);
    }

    @Nullable
    public static ES6ImportSpecifier insertImportSpecifier(final @NotNull ES6ImportDeclaration declaration, @NotNull CreateImportExportInfo info) {
        ASTNode specifier;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertImportSpecifier"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertImportSpecifier"));
        }
        final Project project = declaration.getProject();
        String importedName = info.getImportedName();
        String exportedName = info.getExportedName();
        if (importedName == null && exportedName == null) {
            return null;
        }
        InsertPlaceInDeclaration insertPlace = ES6ImportPsiUtil.getInsertPlace(declaration, exportedName != null ? exportedName : importedName);
        if (insertPlace == null) {
            return null;
        }
        String importText = info.getImportType() == ImportExportType.SPECIFIER ? info.getRawText() : "{default as " + importedName + "}";
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext("import " + importText, (PsiElement)declaration);
        if (importNode == null) {
            return null;
        }
        final PsiElement anchor = insertPlace.getAnchor();
        if (anchor == null) {
            return null;
        }
        final ArrayList elementsToAdd = ContainerUtil.newArrayList();
        if (insertPlace.needBraces()) {
            ASTNode lbrace = importNode.findChildByType(JSTokenTypes.LBRACE);
            if (ES6ImportPsiUtil.isInvalid(lbrace)) {
                return null;
            }
            if (insertPlace.needCommaBefore()) {
                elementsToAdd.add(JSChangeUtil.createCommaPsiElement(project));
            }
            elementsToAdd.add(lbrace.getPsi());
        }
        if (insertPlace.needCommaBefore() && !insertPlace.needBraces()) {
            elementsToAdd.add(JSChangeUtil.createCommaPsiElement(project));
        }
        if (ES6ImportPsiUtil.isInvalid(specifier = importNode.findChildByType((IElementType)ES6ElementTypes.IMPORT_SPECIFIER))) {
            return null;
        }
        elementsToAdd.add(specifier.getPsi());
        if (insertPlace.needCommaAfter()) {
            elementsToAdd.add(JSChangeUtil.createCommaPsiElement(project));
        }
        if (insertPlace.needBraces()) {
            ASTNode rbrace = importNode.findChildByType(JSTokenTypes.RBRACE);
            if (ES6ImportPsiUtil.isInvalid(rbrace)) {
                return null;
            }
            elementsToAdd.add(rbrace.getPsi());
        }
        new WriteCommandAction.Simple<Void>(project, "Add import specifier to import", new PsiFile[]{declaration.getContainingFile()}){

            protected void run() throws Throwable {
                PsiElement currentAnchor = anchor;
                for (PsiElement element : elementsToAdd) {
                    currentAnchor = declaration.addAfter(element, currentAnchor);
                }
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                codeStyleManager.reformat((PsiElement)declaration);
            }
        }.execute();
        String name = info.getExportedName();
        if (name == null) {
            name = importedName;
        }
        return name == null ? null : ES6ImportPsiUtil.findImportSpecifierByReferenceName(declaration, name);
    }

    @Nullable
    public static ES6ImportSpecifier findImportSpecifierByReferenceName(@NotNull ES6ImportDeclaration element, @NotNull String referenceName) {
        ES6ImportSpecifier[] specifiers;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findImportSpecifierByReferenceName"));
        }
        if (referenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "findImportSpecifierByReferenceName"));
        }
        for (ES6ImportSpecifier importSpecifier : specifiers = element.getImportSpecifiers()) {
            if (!referenceName.equals(importSpecifier.getReferenceName())) continue;
            return importSpecifier;
        }
        return null;
    }

    @Contract(value="null->true")
    private static boolean isInvalid(@Nullable ASTNode node) {
        return node == null;
    }

    public static void insertJSImport(@NotNull PsiElement placeToInsert, @NotNull InsertionContext insertionContext, @NotNull LookupElement item) {
        if (placeToInsert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeToInsert", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        if (insertionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertionContext", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (DialectDetector.isTypeScript(placeToInsert)) {
            ES6ImportCompletionUtil.IMPORT_INSERT_HANDLER.handleInsert(insertionContext, item);
            return;
        }
        PsiElement psiElement = item.getPsiElement();
        if (!(psiElement instanceof JSNamedElement)) {
            return;
        }
        PsiFile targetFile = psiElement.getContainingFile().getOriginalFile();
        String name = ((JSNamedElement)psiElement).getName();
        if (name == null) {
            return;
        }
        PsiFile originalFileContext = placeToInsert.getContainingFile();
        VirtualFile root = NodeModuleUtil.findMainModuleRoot(placeToInsert.getProject(), originalFileContext.getVirtualFile());
        if (root == null) {
            return;
        }
        boolean isDefault = ES6ImportHandler.isExportedWithDefault(psiElement);
        ES6ImportPsiUtil.insertJSImport(placeToInsert, name, isDefault ? ImportExportType.DEFAULT : ImportExportType.SPECIFIER, targetFile, insertionContext.getEditor());
    }

    public static void insertJSImport(@NotNull PsiElement contextToInsert, @NotNull String name, @NotNull ImportExportType type, @NotNull PsiFile targetFile, @Nullable Editor editor) {
        VirtualFile placeVirtualFile;
        if (contextToInsert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextToInsert", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "insertJSImport"));
        }
        JSSimpleModuleReferenceInfo referenceInfo = new JSSimpleModuleReferenceInfo(name);
        Project project = contextToInsert.getProject();
        VirtualFile root = NodeModuleUtil.findMainModuleRoot(project, placeVirtualFile = contextToInsert.getContainingFile().getVirtualFile());
        if (root == null) {
            return;
        }
        ModuleFixCreator.FixDescriptor descriptor = NodeJSModulesSearcher.createFixDescriptionFromFile(contextToInsert, referenceInfo, true, root, targetFile, name, ModuleFixCreator.ModuleType.es6);
        if (descriptor == null) {
            return;
        }
        descriptor.setImportType(type);
        ImportES6ModuleFix fix = new ImportES6ModuleFix(contextToInsert, descriptor, JSCodeStyleSettings.getQuote(contextToInsert), false){

            @Override
            protected boolean isAcceptableReference(@Nullable PsiElement element) {
                return true;
            }
        };
        fix.invokeAction(contextToInsert, editor);
    }

    @Nullable
    private static InsertPlaceInDeclaration getInsertPlace(@NotNull ES6ImportDeclaration declaration, @NotNull String name) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getInsertPlace"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getInsertPlace"));
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        ES6FromClause clause = declaration.getFromClause();
        boolean hasBindings = bindings.length > 0;
        ASTNode rightBrace = declaration.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (rightBrace == null) {
            PsiElement anchor;
            if (hasBindings) {
                for (ES6ImportedBinding binding : bindings) {
                    if (!binding.isNamespaceImport()) continue;
                    return null;
                }
            }
            PsiElement psiElement = anchor = clause != null ? clause.getPrevSibling() : null;
            if (anchor == null) {
                ASTNode importKeyword = declaration.getNode().findChildByType(JSTokenTypes.IMPORT_KEYWORD);
                anchor = importKeyword == null ? null : importKeyword.getPsi();
            }
            return ES6ImportPsiUtil.createInsertPlace(anchor, hasBindings && !ES6ImportPsiUtil.hasComma(anchor), false, true);
        }
        if (specifiers.length > 0) {
            boolean needCommaBefore;
            PsiElement anchor;
            return ES6ImportPsiUtil.createInsertPlace(anchor, needCommaBefore, !(needCommaBefore = (anchor = ES6ImportPsiUtil.getSpecifierAnchor(declaration, specifiers, name)) instanceof ES6ImportExportSpecifier), false);
        }
        ASTNode node = declaration.getNode().findChildByType(JSTokenTypes.LBRACE);
        return ES6ImportPsiUtil.createInsertPlace(node == null ? null : node.getPsi(), false, false, false);
    }

    @Nullable
    private static PsiElement getSpecifierAnchor(@NotNull ES6ImportDeclaration declaration, @NotNull ES6ImportSpecifier[] specifiers, @NotNull String name) {
        boolean severalSpecifiers;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getSpecifierAnchor"));
        }
        if (specifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifiers", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getSpecifierAnchor"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getSpecifierAnchor"));
        }
        if (!JSCodeStyleSettings.getSettings((PsiElement)declaration).IMPORT_SORT_MEMBERS) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        List names = Arrays.stream(specifiers).map(el -> el.getReferenceName()).collect(Collectors.toList());
        ArrayList toProcess = ContainerUtil.newArrayList(names);
        Comparator<String> comparator = ES6ImportPsiUtil.getStringImportMemberComparator((PsiElement)declaration);
        boolean bl = severalSpecifiers = toProcess.size() > 1;
        if (severalSpecifiers) {
            ContainerUtil.sort((List)toProcess, comparator);
        }
        if (severalSpecifiers && !toProcess.equals(names)) {
            return (PsiElement)ArrayUtil.getLastElement((Object[])specifiers);
        }
        toProcess.add(name);
        ContainerUtil.sort((List)toProcess, comparator);
        int index = toProcess.indexOf(name);
        if (index == 0) {
            ASTNode lbraceNode = declaration.getNode().findChildByType(JSTokenTypes.LBRACE);
            return lbraceNode == null ? (PsiElement)ArrayUtil.getLastElement((Object[])specifiers) : lbraceNode.getPsi();
        }
        return specifiers[index - 1];
    }

    @NotNull
    private static InsertPlaceInDeclaration createInsertPlace(final @Nullable PsiElement anchor, final boolean needCommaBefore, final boolean needCommaAfter, final boolean needBraces) {
        InsertPlaceInDeclaration insertPlaceInDeclaration = new InsertPlaceInDeclaration(){

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return anchor;
            }

            @Override
            public boolean needCommaBefore() {
                return needCommaBefore;
            }

            @Override
            public boolean needCommaAfter() {
                return needCommaAfter;
            }

            @Override
            public boolean needBraces() {
                return needBraces;
            }
        };
        if (insertPlaceInDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "createInsertPlace"));
        }
        return insertPlaceInDeclaration;
    }

    public static Comparator<String> getStringImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getStringImportMemberComparator"));
        }
        return (o1, o2) -> StringUtil.compare((String)o1, (String)o2, (boolean)true);
    }

    public static Comparator<String> getStringImportFromComparator(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getStringImportFromComparator"));
        }
        return (fromClauseText1, fromClauseText2) -> {
            if (fromClauseText1 != null) {
                if (fromClauseText2 == null) {
                    return 1;
                }
                if (!fromClauseText1.startsWith(".") && fromClauseText2.startsWith(".")) {
                    return -1;
                }
                if (fromClauseText1.startsWith(".") && !fromClauseText2.startsWith(".")) {
                    return 1;
                }
            }
            return StringUtil.compare((String)fromClauseText1, (String)fromClauseText2, (boolean)true);
        };
    }

    public static Comparator<ES6ImportSpecifier> getImportMemberComparator(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getImportMemberComparator"));
        }
        Comparator<String> stringComparator = ES6ImportPsiUtil.getStringImportMemberComparator(context);
        return (o1, o2) -> {
            String name = o1 == null ? null : o1.getReferenceName();
            String name2 = o2 == null ? null : o2.getReferenceName();
            return stringComparator.compare(name, name2);
        };
    }

    @Nullable
    public static ES6ImportExportDeclaration createImportExport(@NotNull PsiElement context, @NotNull CreateImportExportInfo info, @Nullable String quotedModuleName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "createImportExport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "createImportExport"));
        }
        if (quotedModuleName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(info.isImportDeclaration() ? "import " : "export ");
        if (info.getImportType() != ImportExportType.BARE) {
            JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
            builder.append(info.getRawText(settings.SPACES_WITHIN_IMPORTS));
            builder.append(" from ");
        }
        builder.append(quotedModuleName);
        builder.append(JSCodeStyleSettings.getSemicolon(context.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), context);
        if (importNode == null) {
            return null;
        }
        return (ES6ImportExportDeclaration)importNode.getPsi(ES6ImportExportDeclaration.class);
    }

    public static boolean hasNamespaceImport(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "hasNamespaceImport"));
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            if (!binding.isNamespaceImport()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasComma(PsiElement current) {
        boolean hasComma = false;
        for (PsiElement forComma = current; forComma != null; forComma = forComma.getPrevSibling()) {
            if (ES6ImportPsiUtil.isComma(forComma)) {
                hasComma = true;
                break;
            }
            if (!(forComma instanceof PsiWhiteSpace)) break;
        }
        return hasComma;
    }

    @Nullable
    public static String getPathRelativeToRoots(@NotNull PsiElement context, @NotNull VirtualFile placeFile, @NotNull VirtualFile moduleFile) {
        String path;
        ModuleRootManager rootManager;
        Object[] sourceRoots;
        String path2;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getPathRelativeToRoots"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getPathRelativeToRoots"));
        }
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "getPathRelativeToRoots"));
        }
        Project project = context.getProject();
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        if (pathsConfiguration != null && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path2;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, ContainerUtil.newArrayList((Object[])sourceRoots), false)) != null) {
            return path;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(placeFile);
        return contentRoot != null ? VfsUtil.getPath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    private static boolean isComma(@NotNull PsiElement forComma) {
        if (forComma == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forComma", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil", "isComma"));
        }
        return forComma.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    static interface InsertPlaceInDeclaration {
        @Nullable
        public PsiElement getAnchor();

        public boolean needCommaBefore();

        public boolean needCommaAfter();

        public boolean needBraces();
    }

    public static final class ES6ExistingImports {
        @NotNull
        private final Map<String, ES6ImportSpecifier> mySpecifiers;
        @NotNull
        private final Collection<ES6ImportedBinding> myBindings;
        @NotNull
        private final List<ES6ImportDeclaration> myDeclarations;

        public ES6ExistingImports(@NotNull List<ES6ImportDeclaration> declarations) {
            if (declarations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports", "<init>"));
            }
            this.myDeclarations = ContainerUtil.newArrayListWithCapacity((int)declarations.size());
            this.mySpecifiers = ContainerUtil.newHashMap();
            this.myBindings = ContainerUtil.newArrayListWithCapacity((int)declarations.size());
            for (ES6ImportDeclaration declaration : declarations) {
                this.addDeclaration(declaration);
            }
        }

        public void addDeclaration(ES6ImportDeclaration declaration) {
            ES6ImportSpecifier[] specifiers;
            this.myDeclarations.add(declaration);
            for (ES6ImportSpecifier importSpecifier : specifiers = declaration.getImportSpecifiers()) {
                this.mySpecifiers.put(importSpecifier.getReferenceName(), importSpecifier);
            }
            ContainerUtil.addAll(this.myBindings, (Object[])declaration.getImportedBindings());
        }

        public boolean isEmpty() {
            return this.mySpecifiers.isEmpty() && this.myBindings.isEmpty();
        }

        @NotNull
        public Map<String, ES6ImportSpecifier> getSpecifiers() {
            Map<String, ES6ImportSpecifier> map = this.mySpecifiers;
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports", "getSpecifiers"));
            }
            return map;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getBindings() {
            Collection<ES6ImportedBinding> collection = this.myBindings;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports", "getBindings"));
            }
            return collection;
        }

        public void addSpecifier(@NotNull ES6ImportSpecifier specifier) {
            if (specifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports", "addSpecifier"));
            }
            this.mySpecifiers.put(specifier.getReferenceName(), specifier);
        }

        public void addBinding(@NotNull ES6ImportedBinding binding) {
            if (binding == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$ES6ExistingImports", "addBinding"));
            }
            this.myBindings.add(binding);
        }
    }

    public static class CreateImportExportInfo {
        @Nullable
        private final String myExportedName;
        @Nullable
        private final String myImportedName;
        @NotNull
        private final ImportExportType myImportType;
        private final boolean myImportDeclaration;

        @NotNull
        public ImportExportType getImportType() {
            ImportExportType importExportType = this.myImportType;
            if (importExportType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo", "getImportType"));
            }
            return importExportType;
        }

        @Nullable
        public String getExportedName() {
            return this.myExportedName;
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull ImportExportType importType, boolean importDeclaration) {
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo", "<init>"));
            }
            this.myExportedName = exportedName;
            this.myImportedName = importedName;
            this.myImportType = importType;
            this.myImportDeclaration = importDeclaration;
        }

        public CreateImportExportInfo(@NotNull String importedName, @NotNull ImportExportType importType) {
            if (importedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo", "<init>"));
            }
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo", "<init>"));
            }
            this(null, importedName, importType, true);
        }

        public CreateImportExportInfo(@Nullable String importedName) {
            this(null, importedName, ImportExportType.DEFAULT, true);
        }

        public CreateImportExportInfo(@Nullable String exportedName, @Nullable String importedName, @NotNull ImportExportType importType) {
            if (importType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importType", "com/intellij/lang/ecmascript6/psi/impl/ES6ImportPsiUtil$CreateImportExportInfo", "<init>"));
            }
            this(exportedName, importedName, importType, true);
        }

        @Nullable
        public String getImportedName() {
            return this.myImportedName;
        }

        public boolean isImportDeclaration() {
            return this.myImportDeclaration;
        }

        public String getRawText() {
            return this.getRawText(false);
        }

        @Nullable
        public String getRawText(boolean spaces) {
            if (this.myImportType == ImportExportType.SPECIFIER) {
                if (this.myExportedName == null) {
                    return CreateImportExportInfo.wrapWithBraces(this.myImportedName, spaces);
                }
                if (this.myImportedName == null) {
                    return CreateImportExportInfo.wrapWithBraces(this.myExportedName, spaces);
                }
                if (this.myImportedName.equals(this.myExportedName)) {
                    return CreateImportExportInfo.wrapWithBraces(this.myImportedName, spaces);
                }
                return CreateImportExportInfo.wrapWithBraces(this.myExportedName + " as " + this.myImportedName, spaces);
            }
            if (this.myImportType == ImportExportType.IMPORT_BINDING_ALL && this.myImportedName != null) {
                return "* as " + this.myImportedName;
            }
            if (this.myImportType == ImportExportType.DEFAULT && !this.isImportDeclaration()) {
                return CreateImportExportInfo.wrapWithBraces(ES6ImportPsiUtil.DEFAULT.equals(this.myExportedName) ? ES6ImportPsiUtil.DEFAULT : this.myExportedName + " as " + ES6ImportPsiUtil.DEFAULT, spaces);
            }
            if (this.myImportedName != null) {
                return this.myImportedName;
            }
            return this.myExportedName;
        }

        private static String wrapWithBraces(String text, boolean needSpaces) {
            String space = needSpaces ? " " : "";
            return "{" + space + text + space + "}";
        }
    }

    public static enum ImportExportType {
        SPECIFIER,
        DEFAULT,
        IMPORT_BINDING_ALL,
        BARE,
        EXPORT_ALL,
        TS_NS_AND_MODULE{

            @Override
            public boolean isES6() {
                return false;
            }
        }
        ,
        TS_REQUIRE_IMPORT{

            @Override
            public boolean isES6() {
                return false;
            }
        }
        ,
        TS_NAMESPACE{

            @Override
            public boolean isES6() {
                return false;
            }
        };


        public boolean isES6() {
            return true;
        }
    }
}

