/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        PsiElement firstModule = null;
        for (PsiElement element : elements) {
            PsiElement module = ES6MoveModuleMembersHandler.getModule(element);
            if (module == null) {
                return false;
            }
            if (firstModule == null) {
                firstModule = module;
                continue;
            }
            if (firstModule.isEquivalentTo(module)) continue;
            return false;
        }
        return true;
    }

    private static PsiElement getModule(PsiElement element) {
        PsiElement module;
        if (!(element instanceof JSQualifiedNamedElement) && !(element instanceof ES6ExportDefaultAssignment)) {
            return null;
        }
        if (element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        if ((module = JSResolveUtil.findParent(element)) != null && ES6PsiUtil.isExternalModule(module)) {
            return module;
        }
        return null;
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        Language fromLanguage;
        List<JSPsiElementBase> selectedElements;
        super.doMove(project, elements, targetContainer, callback);
        if (elements.length == 0) {
            return;
        }
        PsiElement element = elements[0];
        PsiElement fromModule = ES6PsiUtil.findExternalModule(element);
        if (fromModule == null) {
            return;
        }
        PsiFile containingFile = element.getContainingFile();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
        if (file == null) {
            return;
        }
        String initialPath = StringUtil.notNullize((String)file.getPresentableUrl());
        ES6MoveModuleMembersDialog dialog = new ES6MoveModuleMembersDialog(project, initialPath, initialPath, selectedElements = Arrays.stream(elements).filter(el -> el instanceof JSQualifiedNamedElement).map(el -> (JSQualifiedNamedElement)el).collect(Collectors.toList()), (PsiElement)containingFile);
        if (!dialog.showAndGet()) {
            return;
        }
        String string = dialog.getModuleString();
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(string);
        if (path == null) {
            return;
        }
        PsiFile toModule = PsiManager.getInstance((Project)project).findFile(path);
        if (toModule == null) {
            return;
        }
        Language toModuleLanguage = toModule.getLanguage();
        if (!toModuleLanguage.isKindOf(fromLanguage = fromModule.getLanguage())) {
            CommonRefactoringUtil.showErrorMessage((String)"Error", (String)"Target module has incompatible language", null, (Project)project);
            return;
        }
        boolean openInEditor = dialog.isOpenInEditor();
        ES6MoveModuleMembersProcessor processor = new ES6MoveModuleMembersProcessor(project, dialog.getSelectedElements(), (PsiElement)toModule, fromModule, (Consumer<Collection<JSQualifiedNamedElement>>)((Consumer)newElements -> {
            JSQualifiedNamedElement first;
            dialog.saveOpenInEditorOption();
            if (callback != null) {
                callback.refactoringCompleted();
            }
            if (openInEditor && (first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((Collection)newElements)) != null) {
                EditorHelper.openInEditor((PsiElement)first);
            }
        }));
        processor.setPreviewUsages(dialog.isPreviewUsages());
        try {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)fromModule)) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)toModule)) {
                return;
            }
            processor.run();
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)project);
        }
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, @Nullable PsiReference reference, Editor editor) {
        PsiElement module = ES6MoveModuleMembersHandler.getModule(element);
        if (module != null) {
            this.doMove(project, new PsiElement[]{element}, null, null);
            return true;
        }
        return false;
    }
}

