/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.EmbeddedJsonSchemaFileProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaScriptJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final String[] FILENAMES = new String[]{".babelrc-schema.json", "tsconfig-schema.json", "tsd-schema.json", "typings-schema.json", ".eslintrc-schema.json", ".stylelintrc-schema.json"};
    private static final Map<String, String[]> USER_NAMES = new HashMap<String, String[]>();
    private static final String PATH = "/jsonSchemas";
    private final List<JsonSchemaFileProvider> myProviders;

    public JavaScriptJsonSchemaProviderFactory() {
        ArrayList providers = ContainerUtil.newArrayList();
        String[] stringArray = FILENAMES;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String FILENAME;
            String[] userNames = USER_NAMES.get(FILENAME = stringArray[i]);
            providers.add(JavaScriptJsonSchemaProviderFactory.createProvider(FILENAME, userNames == null ? ArrayUtil.EMPTY_STRING_ARRAY : userNames));
        }
        this.myProviders = providers;
    }

    private static JsonSchemaFileProvider createProvider(@NotNull String filename, String ... userNames) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "createProvider"));
        }
        return new EmbeddedJsonSchemaFileProvider(filename, JavaScriptJsonSchemaProviderFactory.class, "/jsonSchemas/", userNames);
    }

    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "getProviders"));
        }
        List<JsonSchemaFileProvider> list = this.myProviders;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavaScriptJsonSchemaProviderFactory", "getProviders"));
        }
        return list;
    }

    static {
        USER_NAMES.put(".babelrc-schema.json", new String[]{".babelrc"});
        USER_NAMES.put("tsconfig-schema.json", new String[]{"tsconfig.json"});
        USER_NAMES.put("tsd-schema.json", new String[]{"tsd.json"});
        USER_NAMES.put("typings-schema.json", new String[]{"typings.json"});
        USER_NAMES.put(".eslintrc-schema.json", new String[]{".eslintrc.json", ".eslintrc"});
        USER_NAMES.put(".stylelintrc-schema.json", new String[]{".stylelintrc", ".stylelintrc.json"});
    }
}

