/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Settings>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);

    @NotNull
    protected abstract Filter[] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    protected abstract String executable(String var1);

    @NotNull
    protected abstract String[] generatorArgs(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    @NotNull
    protected abstract String presentablePackageName();

    private void generateApp(@NotNull NodeJsLocalInterpreter node, @NotNull Settings settings, @NotNull VirtualFile baseDir, @NotNull Project project) throws IOException, ExecutionException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        File workingDir = this.workingDir(baseDir);
        NpmPackageProjectGenerator.generate(node, this.executable(settings.myPackagePath), baseDir, workingDir, project, this.postInstall(node, project, baseDir, workingDir), this.filters(project, baseDir), this.generatorArgs(project, baseDir, settings));
    }

    protected String[] generatorArgs(Project project, VirtualFile dir, Settings settings) {
        return this.generatorArgs(project, dir);
    }

    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        Runnable runnable = () -> {
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$postInstall$1"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$postInstall$1"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$postInstall$1"));
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (baseDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$0"));
                }
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$0"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$0"));
                }
                if (this.generateInTemp()) {
                    try {
                        FileUtil.copyDir((File)new File(workingDir, baseDir.getName()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                NpmPackageProjectGenerator.initBuildfiles(node, project);
            });
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        return runnable;
    }

    private static void initBuildfiles(@NotNull NodeJsLocalInterpreter node, @NotNull Project project) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "initBuildfiles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "initBuildfiles"));
        }
        if (!project.isDisposed()) {
            NpmScriptsService instance = NpmScriptsService.getInstance();
            List<VirtualFile> buildfiles = instance.detectAllBuildfiles(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$initBuildfiles$2"));
                }
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$initBuildfiles$2"));
                }
                for (VirtualFile buildfile : buildfiles) {
                    instance.getFileManager(project).addBuildfile(buildfile);
                }
                NodeJsInterpreterManager.getInstance(project).setDefault(node);
                instance.getToolWindowManager(project).setAvailable();
                JSLinterGuesser.guessLinters(project);
            });
        }
    }

    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path, final @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, final @Nullable Runnable callback, @NotNull Filter[] filters, String ... args) throws ExecutionException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(node.getInterpreterSystemDependentPath());
        arguments.add(path);
        ContainerUtil.addAll(arguments, (Object[])args);
        GeneralCommandLine commandLine = new GeneralCommandLine(arguments);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project);
        builder.setUsePredefinedMessageFilter(false);
        for (Filter filter : filters) {
            builder.addFilter(filter);
        }
        ConsoleView console = builder.getConsole();
        console.attachToProcess((ProcessHandler)handler);
        ConsoleProgress.install(console, (ProcessHandler)handler);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                baseDir.refresh(false, true);
                baseDir.getChildren();
                handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                if (callback != null) {
                    callback.run();
                }
            }
        });
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        String title = "Generating " + baseDir.getName();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)project);
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)handler, console.getComponent(), title);
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor);
        handler.startNotify();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        NodeJsInterpreter interpreter = settings.myInterpreter;
        NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
        assert (local != null);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$4"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$4"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$4"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$4"));
            }
            try {
                this.generateApp(local, settings, baseDir, project);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                this.customizeModule(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$3"));
                    }
                    model.commit();
                    project.save();
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<Settings> createPeer() {
        NpmPackageGeneratorPeer npmPackageGeneratorPeer = new NpmPackageGeneratorPeer();
        if (npmPackageGeneratorPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "createPeer"));
        }
        return npmPackageGeneratorPeer;
    }

    @NotNull
    private File workingDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "workingDir"));
        }
        if (this.generateInTemp()) {
            File file = Files.createTempDir();
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "workingDir"));
            }
            return file;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "workingDir"));
        }
        return file;
    }

    protected boolean generateInTemp() {
        return false;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "validateProjectPath"));
        }
        return null;
    }

    protected class NpmPackageGeneratorPeer
    implements WebProjectGenerator.GeneratorPeer<Settings> {
        public final JPanel myPanel = this.createPanel();
        private NodeJsInterpreterField myInterpreter;
        private NodePackageField myPackageField;
        private TextAccessor myLocation;

        protected JPanel createPanel() {
            Project project = ProjectManager.getInstance().getDefaultProject();
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myInterpreter = new NodeJsInterpreterField(project, false){

                @Override
                public boolean isDefaultProjectInterpreterField() {
                    return true;
                }
            };
            this.myInterpreter.setInterpreter(NodeJsInterpreterManager.getInstance(project).getDefault());
            LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreter), (String)"Node &interpreter:");
            component.setLabelLocation("West");
            panel.add((Component)component);
            this.myPackageField = new NodePackageField(project, NpmPackageProjectGenerator.this.packageName(), () -> this.myInterpreter.getInterpreter());
            this.myPackageField.setSelected(NodePackage.findPreferredPackage(project, NpmPackageProjectGenerator.this.packageName(), this.myInterpreter.getInterpreter()));
            component = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)NpmPackageProjectGenerator.this.presentablePackageName());
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            JPanel myPanel = panel;
            return myPanel;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "getComponent"));
            }
            return jPanel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            if (settingsStep == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "buildUI"));
            }
            JTextField field = settingsStep.getModuleNameField();
            if (field != null) {
                Component component = field.getParent().getComponent(3);
                this.myLocation = component instanceof TextAccessor ? (TextAccessor)component : null;
            }
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Node &interpreter:"), (JComponent)((Object)this.myInterpreter));
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)NpmPackageProjectGenerator.this.presentablePackageName()), (JComponent)((Object)this.myPackageField));
        }

        @NotNull
        public Settings getSettings() {
            Settings settings = new Settings(this.myInterpreter.getInterpreter(), this.myPackageField.getSelected().getSystemDependentPath());
            if (settings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "getSettings"));
            }
            return settings;
        }

        @Nullable
        public ValidationInfo validate() {
            String validateMessage;
            NodeJsInterpreter interpreter = this.myInterpreter.getInterpreter();
            String error = NodeJsLocalInterpreter.getErrorMessage(interpreter);
            if (error != null) {
                return new ValidationInfo(error);
            }
            String pkgError = this.myPackageField.getSelected().getErrorMessage(NpmPackageProjectGenerator.this.packageName());
            if (pkgError != null) {
                return new ValidationInfo(pkgError);
            }
            if (this.myLocation == null) {
                Component component = this.myInterpreter.getParent().getParent().getComponent(0);
                this.myLocation = component instanceof LabeledComponent ? (TextAccessor)((LabeledComponent)component).getComponent() : null;
            }
            String string = validateMessage = this.myLocation != null ? NpmPackageProjectGenerator.this.validateProjectPath(this.myLocation.getText()) : null;
            if (validateMessage != null) {
                return new ValidationInfo(validateMessage);
            }
            return null;
        }

        public boolean isBackgroundJobRunning() {
            return false;
        }

        public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "addSettingsStateListener"));
            }
            this.myInterpreter.addChangeListener(interpreter -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "lambda$addSettingsStateListener$1"));
                }
                listener.stateChanged(this.validate() == null);
            });
            this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer", "lambda$addSettingsStateListener$2"));
                }
                listener.stateChanged(this.validate() == null);
            }));
            listener.stateChanged(this.validate() == null);
        }
    }

    public static class Settings
    extends UserDataHolderBase {
        public NodeJsInterpreter myInterpreter;
        public String myPackagePath;

        public Settings(NodeJsInterpreter interpreter, String text) {
            this.myInterpreter = interpreter;
            this.myPackagePath = text;
        }
    }
}

