/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.lang.javascript.bower.BowerPackagingService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.packaging.InstalledPackagesPanel;
import com.intellij.webcore.packaging.ManagePackagesDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerInstalledPackagesPanel
extends InstalledPackagesPanel {
    public BowerInstalledPackagesPanel(@NotNull Project project, @NotNull PackagesNotificationPanel area) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerInstalledPackagesPanel", "<init>"));
        }
        if (area == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/lang/javascript/bower/BowerInstalledPackagesPanel", "<init>"));
        }
        super(project, area);
    }

    public void updatePackages(@Nullable PackageManagementService packageManagementService) {
        BowerPackagingService bowerService = (BowerPackagingService)((Object)ObjectUtils.tryCast((Object)packageManagementService, BowerPackagingService.class));
        if (bowerService != null) {
            BowerInstalledPackagesPanel.saveBowerConfig(bowerService);
        }
        this.myInstallButton.setEnabled(bowerService != null);
        super.updatePackages(packageManagementService);
    }

    private static void saveBowerConfig(@NotNull BowerPackagingService bowerService) {
        if (bowerService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerService", "com/intellij/lang/javascript/bower/BowerInstalledPackagesPanel", "saveBowerConfig"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            FileDocumentManager fileDocumentManager;
            Document document;
            VirtualFile vFile;
            if (bowerService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerService", "com/intellij/lang/javascript/bower/BowerInstalledPackagesPanel", "lambda$saveBowerConfig$0"));
            }
            File file = new File(bowerService.getSettings().getBowerJsonPath());
            if (file.isFile() && (vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false)) != null && vFile.isValid() && (document = (fileDocumentManager = FileDocumentManager.getInstance()).getDocument(vFile)) != null) {
                fileDocumentManager.saveDocument(document);
            }
        });
    }

    @NotNull
    protected ManagePackagesDialog createManagePackagesDialog() {
        ManagePackagesDialog dialog = super.createManagePackagesDialog();
        dialog.setOptionsText("--save");
        ManagePackagesDialog managePackagesDialog = dialog;
        if (managePackagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerInstalledPackagesPanel", "createManagePackagesDialog"));
        }
        return managePackagesDialog;
    }
}

