/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtUtil {
    private static final Logger LOG = Logger.getInstance(JsbtUtil.class);
    private static final char BELL = '\u0007';
    private static final String BELL_STR = String.valueOf('\u0007');
    private static final char EIGHTH_NOTE = '\u266a';

    private JsbtUtil() {
    }

    public static void iterateOverContentRoots(@NotNull Project project, boolean webModulesOnly, @NotNull Consumer<VirtualFile> contentRootConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "iterateOverContentRoots"));
        }
        if (contentRootConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRootConsumer", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "iterateOverContentRoots"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (webModulesOnly && !WebModuleTypeBase.isWebModule((Module)module)) continue;
            LOG.info("Iterating over content roots for module " + module.getModuleFilePath());
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                LOG.info("Detecting in content root " + contentRoot.getPath());
                contentRootConsumer.consume((Object)contentRoot);
            }
        }
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions, boolean includeDirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        List buildfiles = ContainerUtil.newSmartList();
        JsbtUtil.iterateOverContentRoots(project, webModulesOnly, (Consumer<VirtualFile>)((Consumer)contentRoot -> {
            if (filenamePrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$detectAllBuildfilesInContentRoots$0"));
            }
            if (filenameExtensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$detectAllBuildfilesInContentRoots$0"));
            }
            VirtualFile buildfile = JsbtUtil.detectBuildfile(contentRoot, filenamePrefix, filenameExtensions, includeDirs);
            if (buildfile != null) {
                buildfiles.add(buildfile);
            }
        }));
        List list = buildfiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @Nullable
    private static VirtualFile detectBuildfile(@NotNull VirtualFile dir, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions, boolean includeDirs) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectBuildfile"));
        }
        Object result = null;
        Object[] children = (VirtualFile[])ObjectUtils.notNull((Object)dir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
        LOG.info("Detecting by children: " + Arrays.toString(children));
        for (Object child : children) {
            if (!child.isValid() || !includeDirs && child.isDirectory() || !JsbtUtil.isFilenameMatched(child.getNameSequence(), filenamePrefix, filenameExtensions)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            if (JsbtUtil.compareExt((VirtualFile)child, (VirtualFile)result, filenameExtensions) >= 0) continue;
            result = child;
        }
        return result;
    }

    private static int compareExt(@NotNull VirtualFile file1, @NotNull VirtualFile file2, @NotNull String[] extensions) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "compareExt"));
        }
        int ind1 = ArrayUtil.find((Object[])extensions, (Object)file1.getExtension());
        int ind2 = ArrayUtil.find((Object[])extensions, (Object)file2.getExtension());
        if (ind1 < 0) {
            ind1 = extensions.length;
        }
        if (ind2 < 0) {
            ind2 = extensions.length;
        }
        return ind1 - ind2;
    }

    public static boolean isFilenameMatched(@NotNull CharSequence fileName, @NotNull String filenamePrefix, @NotNull String[] filenameExtensions) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (filenameExtensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenameExtensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "isFilenameMatched"));
        }
        if (JsbtUtil.startsWithIgnoreCase(fileName, filenamePrefix)) {
            for (String ext : filenameExtensions) {
                if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)ext)) continue;
                return ext.length() < fileName.length() && '.' == fileName.charAt(fileName.length() - ext.length() - 1);
            }
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull CharSequence text, @NonNls @NotNull CharSequence prefix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "startsWithIgnoreCase"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "startsWithIgnoreCase"));
        }
        int prefixLength = prefix.length();
        if (text.length() < prefixLength) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (StringUtil.charsEqualIgnoreCase((char)text.charAt(i), (char)prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfiles(@NotNull Project project, @NotNull String filenamePrefix, @NotNull String[] filenamesWithoutExt, @NotNull String[] extensions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (filenamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamePrefix", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (filenamesWithoutExt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamesWithoutExt", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        HashSet result = ContainerUtil.newHashSet();
        result.addAll(JsbtUtil.detectAllBuildfilesInContentRoots(project, false, filenamePrefix, extensions, false));
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$detectAllBuildfiles$1"));
            }
            if (filenamesWithoutExt == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filenamesWithoutExt", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$detectAllBuildfiles$1"));
            }
            if (extensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$detectAllBuildfiles$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            GlobalSearchScope scope = JsbtUtil.getContentScopeWithoutLibraries(project);
            for (String nameWithoutExt : filenamesWithoutExt) {
                for (String ext : extensions) {
                    result.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)(nameWithoutExt + "." + ext), (boolean)false, (GlobalSearchScope)scope));
                }
            }
        });
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)result);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "detectAllBuildfiles"));
        }
        return arrayList;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile root;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        if (!project.isDisposed() && (root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file)) != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getRelativePath"));
        }
        return string;
    }

    public static void foldCommandLine(@NotNull ConsoleView consoleView, final @NotNull ProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        String commandLine;
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldCommandLine"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldCommandLine"));
        }
        if (foldedCommandLineText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedCommandLineText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldCommandLine"));
        }
        BaseOSProcessHandler osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class);
        String string = commandLine = osProcessHandler != null ? osProcessHandler.getCommandLine() : null;
        if (commandLine == null) {
            return;
        }
        final ConsoleViewImpl consoleViewImpl = JsbtUtil.getConsoleViewImpl(consoleView);
        if (consoleViewImpl == null) {
            return;
        }
        if (consoleView instanceof SMTRunnerConsoleView) {
            JsbtUtil.doFoldForTestConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
        } else if (processHandler.isStartNotified()) {
            JsbtUtil.doFoldForRegularConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    processHandler.removeProcessListener((ProcessListener)this);
                    JsbtUtil.doFoldForRegularConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
                }
            });
        }
    }

    public static void foldMatchingTextAtOffset(@NotNull ConsoleView consoleView, int matchingTextDocumentStartOffset, @NotNull String matchingText, @NotNull String foldedText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        if (matchingText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        if (foldedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "foldMatchingTextAtOffset"));
        }
        ConsoleViewImpl consoleViewImpl = JsbtUtil.getConsoleViewImpl(consoleView);
        if (consoleViewImpl == null) {
            return;
        }
        if (consoleView instanceof SMTRunnerConsoleView) {
            JsbtUtil.doFoldForTestConsole(consoleViewImpl, matchingTextDocumentStartOffset, matchingText, foldedText);
        } else {
            JsbtUtil.doFoldForRegularConsole(consoleViewImpl, matchingTextDocumentStartOffset, matchingText, foldedText);
        }
    }

    private static void doFoldForTestConsole(@NotNull ConsoleViewImpl consoleView, final int matchingTextDocumentStartOffset, final @NotNull String matchingText, final @NotNull String foldedText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForTestConsole"));
        }
        if (matchingText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForTestConsole"));
        }
        if (foldedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForTestConsole"));
        }
        final Editor editor = consoleView.getEditor();
        final Document doc = editor.getDocument();
        doc.addDocumentListener(new DocumentListener(){
            private Ref<FoldRegion> myFoldRegionRef;

            public void documentChanged(DocumentEvent e) {
                if (doc.getTextLength() == 0) {
                    FoldRegion foldRegion = this.myFoldRegionRef != null ? (FoldRegion)this.myFoldRegionRef.get() : null;
                    this.myFoldRegionRef = null;
                    if (foldRegion != null) {
                        EditorUtil.runBatchFoldingOperationOutsideOfBulkUpdate((Editor)editor, () -> {
                            FoldingModel foldingModel = editor.getFoldingModel();
                            foldingModel.removeFoldRegion(foldRegion);
                        });
                    }
                } else if (this.myFoldRegionRef == null && doc.getTextLength() >= matchingTextDocumentStartOffset + matchingText.length()) {
                    this.myFoldRegionRef = Ref.create();
                    if (CharArrayUtil.regionMatches((CharSequence)doc.getCharsSequence(), (int)matchingTextDocumentStartOffset, (CharSequence)matchingText)) {
                        EditorUtil.runBatchFoldingOperationOutsideOfBulkUpdate((Editor)editor, () -> {
                            if (matchingText == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$2", "lambda$documentChanged$1"));
                            }
                            if (foldedText == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$2", "lambda$documentChanged$1"));
                            }
                            FoldingModel foldingModel = editor.getFoldingModel();
                            FoldRegion region = foldingModel.addFoldRegion(matchingTextDocumentStartOffset, matchingTextDocumentStartOffset + matchingText.length(), foldedText);
                            if (region != null) {
                                region.setExpanded(false);
                            }
                            this.myFoldRegionRef = Ref.create((Object)region);
                        });
                    }
                }
            }
        });
    }

    private static void doFoldForRegularConsole(@NotNull ConsoleViewImpl consoleView, int matchingTextDocumentStartOffset, @NotNull String matchingText, @NotNull String foldedText) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForRegularConsole"));
        }
        if (matchingText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForRegularConsole"));
        }
        if (foldedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "doFoldForRegularConsole"));
        }
        consoleView.flushDeferredText();
        consoleView.performWhenNoDeferredOutput(() -> {
            if (consoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$doFoldForRegularConsole$3"));
            }
            if (matchingText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$doFoldForRegularConsole$3"));
            }
            if (foldedText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$doFoldForRegularConsole$3"));
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            Document document = consoleView.getEditor().getDocument();
            if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)matchingTextDocumentStartOffset, (CharSequence)matchingText)) {
                FoldingModel foldingModel = consoleView.getEditor().getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    if (matchingText == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$null$2"));
                    }
                    if (foldedText == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldedText", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "lambda$null$2"));
                    }
                    FoldRegion region = foldingModel.addFoldRegion(matchingTextDocumentStartOffset, matchingTextDocumentStartOffset + matchingText.length(), foldedText);
                    if (region != null) {
                        region.setExpanded(false);
                    }
                });
            }
        });
    }

    private static ConsoleViewImpl getConsoleViewImpl(@NotNull ConsoleView consoleView) {
        SMTRunnerConsoleView smtConsoleView;
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getConsoleViewImpl"));
        }
        ConsoleViewImpl consoleViewImpl = (ConsoleViewImpl)ObjectUtils.tryCast((Object)consoleView, ConsoleViewImpl.class);
        if (consoleViewImpl == null && (smtConsoleView = (SMTRunnerConsoleView)ObjectUtils.tryCast((Object)consoleView, SMTRunnerConsoleView.class)) != null) {
            consoleViewImpl = (ConsoleViewImpl)ObjectUtils.tryCast((Object)smtConsoleView.getConsole(), ConsoleViewImpl.class);
        }
        return consoleViewImpl;
    }

    public static boolean equalsOrderless(@NotNull List<String> a, @NotNull List<String> b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "equalsOrderless"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "equalsOrderless"));
        }
        if (a.size() <= 1 || b.size() <= 1) {
            return a.equals(b);
        }
        List<String> as = JsbtUtil.sort(a);
        List<String> bs = JsbtUtil.sort(b);
        return as.equals(bs);
    }

    @NotNull
    private static List<String> sort(@NotNull List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "sort"));
        }
        Object[] array = ArrayUtil.toStringArray(list);
        Arrays.sort(array);
        List<Object> list2 = Arrays.asList(array);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "sort"));
        }
        return list2;
    }

    @Nullable
    public static JsbtInvalidSetting validatePackageDir(@NotNull String packageDir, @NotNull String name, @NotNull String packageName) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "validatePackageDir"));
        }
        if (StringUtil.isEmptyOrSpaces((String)packageDir)) {
            return new JsbtInvalidSetting(name, packageDir, "Please specify " + packageName + " package");
        }
        File dir = new File(packageDir);
        if (!dir.isAbsolute() || !dir.isDirectory()) {
            return new JsbtInvalidSetting(name, packageDir, "Please specify " + packageName + " package directory correctly");
        }
        return null;
    }

    @NotNull
    public static ProcessHandler createProcessHandlerWithBeepSupport(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "createProcessHandlerWithBeepSupport"));
        }
        KillableColoredProcessHandler killableColoredProcessHandler = new KillableColoredProcessHandler(commandLine, true){
            private boolean myPreviousBellChar = false;

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$3", "coloredTextAvailable"));
                }
                if (attributes == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$3", "coloredTextAvailable"));
                }
                if (text != null && ProcessOutputTypes.SYSTEM != attributes && ProcessOutputTypes.STDERR != attributes) {
                    boolean bellCharFound = false;
                    for (int i = 0; i < text.length(); ++i) {
                        char ch = text.charAt(i);
                        if (this.myPreviousBellChar && ch == '\u266a') {
                            UIUtil.invokeLaterIfNeeded(() -> Toolkit.getDefaultToolkit().beep());
                        }
                        boolean bellChar = ch == '\u0007';
                        bellCharFound |= bellChar;
                        this.myPreviousBellChar = bellChar;
                    }
                    if (bellCharFound) {
                        text = StringUtil.replace((String)text, (String)BELL_STR, (String)"");
                    }
                }
                super.coloredTextAvailable(text, attributes);
            }
        };
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "createProcessHandlerWithBeepSupport"));
        }
        return killableColoredProcessHandler;
    }

    public static List<String> encodeNames(@NotNull List<String> rawNames) {
        if (rawNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawNames", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "encodeNames"));
        }
        return ContainerUtil.map(rawNames, name -> ParametersListUtil.join(Collections.singletonList(name)));
    }

    @NotNull
    public static GlobalSearchScope getContentScopeWithoutLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getContentScopeWithoutLibraries"));
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        final ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        GlobalSearchScope globalSearchScope = scope.intersectWith(new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$4", "contains"));
                }
                return file.isValid() && !file.isDirectory() && !JSLibraryUtil.isProbableLibraryFile(file) && !fileIndex.isInLibraryClasses(file) && !fileIndex.isInLibrarySource(file);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$4", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$4", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$4", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        });
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtUtil", "getContentScopeWithoutLibraries"));
        }
        return globalSearchScope;
    }

    public static boolean hasBuildTool(Project project) {
        return GruntfileManager.getInstance(project).hasBuildfiles() || GulpfileManager.getInstance(project).hasBuildfiles();
    }
}

