/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String TEMPLATE_NAME = "package_json";
    private static final List<String> DEPENDENCIES_KEY = ContainerUtil.newArrayList((Object[])new String[]{"dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies"});

    private PackageJsonUtil() {
    }

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isInsidePackageJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        return file != null && PackageJsonUtil.isPackageJsonFile(file);
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getContainingPackageJsonFile"));
        }
        PsiFile file = element.getContainingFile();
        return PackageJsonUtil.isPackageJsonFile(file) ? (JsonFile)file : null;
    }

    public static boolean isPackageJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && FILE_NAME.equals(file.getName());
    }

    public static boolean isPackageJsonFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageJsonFile"));
        }
        return !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isTopLevelProperty"));
        }
        PsiElement parent = property.getParent();
        return parent != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "findContainingProperty"));
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element) {
        if (element == null || !PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPackageDependencyProperty"));
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class);
        if (obj != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && DEPENDENCIES_KEY.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean hasScope(@NotNull String dependencyName, @NotNull String scopeName) {
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "hasScope"));
        }
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "hasScope"));
        }
        return dependencyName.startsWith(scopeName) && dependencyName.length() > scopeName.length() && dependencyName.charAt(scopeName.length()) == '/';
    }

    @NotNull
    public static List<VirtualFile> collectPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "collectPackageJsonFiles"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "collectPackageJsonFiles"));
        }
        ArrayList results = ContainerUtil.newArrayList();
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<VirtualFile>)((Processor)file -> {
            results.add(file);
            return true;
        }));
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "collectPackageJsonFiles"));
        }
        return arrayList;
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "processUpPackageJsonFiles"));
        }
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "processUpPackageJsonFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "processUpPackageJsonFiles"));
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "lambda$processUpPackageJsonFiles$1"));
            }
            if (fileOrDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "lambda$processUpPackageJsonFiles$1"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "lambda$processUpPackageJsonFiles$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
            while (dir != null && contentRoot != null) {
                VirtualFile packageJson = dir.findChild(FILE_NAME);
                if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory() && !processor.process((Object)packageJson)) {
                    return;
                }
                if (dir.equals(contentRoot)) {
                    if ((dir = dir.getParent()) == null) {
                        return;
                    }
                    contentRoot = fileIndex.getContentRootForFile(dir, false);
                    continue;
                }
                dir = dir.getParent();
            }
        });
    }

    @NotNull
    public static List<JsonProperty> listAllPackageProperties(@NotNull JsonFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "listAllPackageProperties"));
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!DEPENDENCIES_KEY.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "listAllPackageProperties"));
        }
        return arrayList;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJson, false);
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson, boolean refresh) {
        long documentModificationStamp;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        if (refresh) {
            VfsUtil.markDirtyAndRefresh((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
        long l = documentModificationStamp = document != null ? document.getModificationStamp() : -1L;
        if (cached == null || cached.getFileModificationStamp() != packageJson.getModificationStamp() || cached.getDocumentModificationStamp() != documentModificationStamp) {
            PackageJsonData data = PackageJsonData.parse(packageJson, document);
            cached = new CachedPackageJsonData(data, packageJson.getModificationStamp(), documentModificationStamp);
            CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
        }
        PackageJsonData packageJsonData = cached.getData();
        if (packageJsonData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getOrCreateData"));
        }
        return packageJsonData;
    }

    @Nullable
    public static PsiFile createPackageJson(@NotNull PsiDirectory psiDir, boolean openFile) {
        VirtualFile virtualFile;
        if (psiDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDir", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "createPackageJson"));
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate(TEMPLATE_NAME);
        Map<String, String> defaultValues = Collections.singletonMap("package_name", psiDir.getName());
        if (!openFile) {
            String text = template.getText();
            for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
                text = text.replace("#[[$" + entry.getKey() + "$]]#", entry.getValue());
            }
            template = template.clone();
            template.setText(text.replace("#[[$END$]]#", ""));
        }
        template.setLiveTemplateEnabled(openFile);
        PsiFile file = CreateFileFromTemplateAction.createFileFromTemplate((String)FILE_NAME, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)openFile, defaultValues);
        if (openFile && file != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true);
        }
        return file;
    }

    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getTopLevelPackageJsonData"));
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = project.getBaseDir().findChild(FILE_NAME);
        return packageJson == null ? null : PackageJsonUtil.getOrCreateData(packageJson, false);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionText", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isVersionGreaterOrEqualMajor"));
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (sb.length() > 0) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getMajorVersion"));
        }
        int idx = version.indexOf(".");
        if (idx < 0) {
            return StringUtil.parseInt((String)version, (int)-1);
        }
        return StringUtil.parseInt((String)version.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "isPrefixValid"));
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil", "getVersionComparator"));
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;

        /*
         * WARNING - void declaration
         */
        public CachedPackageJsonData(@NotNull PackageJsonData data, long fileModificationStamp, long l) {
            void documentModificationStamp;
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "<init>"));
            }
            this.myData = data;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData", "getData"));
            }
            return packageJsonData;
        }

        public long getFileModificationStamp() {
            return this.myFileModificationStamp;
        }

        public long getDocumentModificationStamp() {
            return this.myDocumentModificationStamp;
        }

        public String toString() {
            return "data=" + this.myData + ", fileModificationStamp=" + this.myFileModificationStamp + ", documentModificationStamp=" + this.myDocumentModificationStamp;
        }
    }
}

