/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final String[] TYPE_LITERAL_VALUES = new String[]{"true", "false", "null"};
    private static final String[] KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE = new String[]{"true", "false", "null", "break", "continue", "default", "debugger", "return", "this"};
    private static final String[] DEFAULT_KEYWORDS_WITH_WHITESPACE = new String[]{"const", "delete", "new", "throw", "typeof", "var", "void", "with"};
    private static final Template FUNCTION_TEMPLATE = new TemplateImpl("", " $NAME$($PARAMS$) {\n  $END$\n}", "");
    private static final Template FUNCTION_EXPRESSION_TEMPLATE = new TemplateImpl("", "($PARAMS$) {\n  $END$\n}", "");
    private static final InsertHandler<LookupElement> FUNCTION_KEYWORD_INSERT_HANDLER;

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "addCompletions"));
        }
        PsiFile containingFile = parameters.getPosition().getContainingFile().getOriginalFile();
        List<Object> variants = containingFile instanceof JSExpressionCodeFragment ? ((JSExpressionCodeFragment)containingFile).getTopLevelVariants(parameters.getPosition()) : Arrays.asList(JSKeywordsCompletionProvider.getDefaultKeywordVariants(parameters.getPosition()));
        ArrayList<LookupItem> lookupElements = new ArrayList<LookupItem>(variants.size());
        for (Object variant : variants) {
            lookupElements.add((LookupItem)(variant instanceof LookupItem ? ((LookupItem)variant).setBold() : (variant instanceof LookupElement ? (LookupElement)variant : LookupElementBuilder.create((String)variant.toString()).bold())));
        }
        result.addAllElements(lookupElements);
    }

    @NotNull
    public static LookupElement[] getDefaultKeywordVariants(@NotNull PsiElement context) {
        KeywordCompletionConsumer consumer;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
        }
        ArrayList<Trinity<String, JSLookupPriority, Boolean>> keywords = new ArrayList<Trinity<String, JSLookupPriority, Boolean>>();
        JSCompletionKeywordsContributor contributor = JSHandlersFactory.forElement(context).newCompletionKeywordsContributor();
        if (!contributor.process(consumer = JSKeywordsCompletionProvider.createKeywordConsumer(keywords), context)) {
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        PsiElement parent = context.getParent();
        if (JSKeywordsCompletionProvider.isNoKeywordsContext(context, parent)) {
            if (LookupElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (JSKeywordsCompletionProvider.isCaseClauseContext(context, parent)) {
            JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(context);
        PsiElement grandParent = parent.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null || parent.textContains('.') || parent.textContains(':')) {
                if (LookupElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return LookupElement.EMPTY_ARRAY;
            }
            if (grandParent instanceof JSNewExpression) {
                boolean appendSpace = JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, appendSpace, "function");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSDoWhileStatement) {
                boolean appendSpace = commonSettings.SPACE_BEFORE_WHILE_PARENTHESES;
                JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "while");
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
            if (grandParent instanceof JSStatement) {
                boolean appendSpace;
                PsiElement prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)grandParent, JSStatement.class);
                if (prevStatement instanceof JSIfStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_ELSE_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "else");
                } else if (prevStatement instanceof JSTryStatement) {
                    appendSpace = commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "catch");
                    appendSpace = commonSettings.SPACE_BEFORE_FINALLY_LBRACE;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace, "finally");
                }
                if (grandParent instanceof JSExpressionStatement) {
                    PsiElement grandParentParent;
                    PsiElement prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(grandParent);
                    if (prevSibling != null && prevSibling.getNode().getElementType() == JSTokenTypes.ELSE_KEYWORD) {
                        boolean appendSpace2 = commonSettings.SPACE_BEFORE_IF_PARENTHESES;
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, appendSpace2, "if");
                    }
                    if ((grandParentParent = grandParent.getParent()) instanceof JSCaseClause) {
                        JSKeywordsCompletionProvider.appendCaseKeywords(keywords);
                    }
                    if (grandParentParent instanceof JSForStatement) {
                        if (prevSibling instanceof PsiErrorElement) {
                            prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(prevSibling);
                        }
                        if (prevSibling instanceof JSVarStatement) {
                            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "of", "in");
                            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
                            if (lookupElementArray == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                            }
                            return lookupElementArray;
                        }
                    } else if (JSKeywordsCompletionProvider.isContextForOperation(prevSibling)) {
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "in");
                        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, "instanceof");
                    }
                }
            } else {
                if (JSKeywordsCompletionProvider.isES6ShortHandedProperty(parent, grandParent)) {
                    if (LookupElement.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                    }
                    return LookupElement.EMPTY_ARRAY;
                }
                boolean isComparison = JSKeywordsCompletionProvider.isComparisonContext(grandParent);
                boolean isAssignment = JSKeywordsCompletionProvider.isAssignmentContext(grandParent);
                JSLookupPriority priority = JSLookupPriority.KEYWORDS_PRIORITY;
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, TYPE_LITERAL_VALUES);
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, false, "this");
                if (isAssignment || !isComparison) {
                    boolean appendSpace = commonSettings.SPACE_BEFORE_METHOD_PARENTHESES;
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpace, "function");
                }
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "typeof");
                if (isAssignment || !isComparison) {
                    JSKeywordsCompletionProvider.appendKeywords(keywords, priority, true, "new");
                }
                contributor.appendExpressionContextKeywords(consumer);
                LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
                if (lookupElementArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
                }
                return lookupElementArray;
            }
        }
        if (JSKeywordsCompletionProvider.isEmbeddedContentExpression(grandParent)) {
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, TYPE_LITERAL_VALUES);
            JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.KEYWORDS_PRIORITY, false, "int", "uint");
            LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
            if (lookupElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
            }
            return lookupElementArray;
        }
        JSKeywordsCompletionProvider.appendDefaultKeywords(keywords, context, commonSettings);
        contributor.appendSpecificKeywords(consumer);
        LookupElement[] lookupElementArray = JSKeywordsCompletionProvider.createKeywordItems(keywords);
        if (lookupElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "getDefaultKeywordVariants"));
        }
        return lookupElementArray;
    }

    private static boolean isContextForOperation(@Nullable PsiElement prevSibling) {
        if (prevSibling instanceof PsiErrorElement) {
            return true;
        }
        if (!(prevSibling instanceof JSVarStatement)) {
            return false;
        }
        JSVarStatement prev = (JSVarStatement)prevSibling;
        PsiElement child = prev.getLastChild();
        return child == null || child.getNode().getElementType() != JSTokenTypes.SEMICOLON;
    }

    @NotNull
    private static KeywordCompletionConsumer createKeywordConsumer(final List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        KeywordCompletionConsumer keywordCompletionConsumer = new KeywordCompletionConsumer(){

            @Override
            public void consume(JSLookupPriority priority, boolean appendSpaces, String ... contributorKeywords) {
                JSKeywordsCompletionProvider.appendKeywords(keywords, priority, appendSpaces, contributorKeywords);
            }
        };
        if (keywordCompletionConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "createKeywordConsumer"));
        }
        return keywordCompletionConsumer;
    }

    private static boolean isComparisonContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign());
    }

    private static boolean isAssignmentContext(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSArgumentList || grandParent instanceof JSBinaryExpression && ((JSBinaryExpression)grandParent).getOperationSign() == JSTokenTypes.EQ;
    }

    private static void appendDefaultKeywords(@NotNull List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull PsiElement context, @NotNull CommonCodeStyleSettings commonSettings) {
        if (keywords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywords", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "appendDefaultKeywords"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "appendDefaultKeywords"));
        }
        if (commonSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonSettings", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "appendDefaultKeywords"));
        }
        ArrayList withoutSpace = new ArrayList(30);
        ContainerUtil.addAll(withoutSpace, (Object[])KEYWORDS_FOLLOWED_NOT_ONLY_BY_SPACE);
        ArrayList<String> withSpace = new ArrayList<String>(20);
        ContainerUtil.addAll(withSpace, (Object[])DEFAULT_KEYWORDS_WITH_WHITESPACE);
        (commonSettings.SPACE_BEFORE_WHILE_PARENTHESES ? withSpace : withoutSpace).add("while");
        (commonSettings.SPACE_BEFORE_DO_LBRACE ? withSpace : withoutSpace).add("do");
        (commonSettings.SPACE_BEFORE_ELSE_LBRACE ? withSpace : withoutSpace).add("else");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("each");
        (commonSettings.SPACE_BEFORE_FINALLY_LBRACE ? withSpace : withoutSpace).add("finally");
        (commonSettings.SPACE_BEFORE_FOR_PARENTHESES ? withSpace : withoutSpace).add("for");
        (JSCodeStyleSettings.getSettings((PsiElement)context).SPACE_BEFORE_FUNCTION_LEFT_PARENTH ? withSpace : withoutSpace).add("function");
        (commonSettings.SPACE_BEFORE_IF_PARENTHESES ? withSpace : withoutSpace).add("if");
        (commonSettings.SPACE_BEFORE_TRY_LBRACE ? withSpace : withoutSpace).add("try");
        (commonSettings.SPACE_BEFORE_CATCH_PARENTHESES ? withSpace : withoutSpace).add("catch");
        (commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES ? withSpace : withoutSpace).add("switch");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, ArrayUtil.toStringArray(withoutSpace));
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, ArrayUtil.toStringArray(withSpace));
    }

    private static boolean isCaseClauseContext(@NotNull PsiElement context, PsiElement parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "isCaseClauseContext"));
        }
        return parent instanceof JSCaseClause && JSUtils.getChildExcludingTypes(parent, PsiErrorElement.class, PsiWhiteSpace.class) == context;
    }

    private static boolean isNoKeywordsContext(@NotNull PsiElement context, PsiElement parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "isNoKeywordsContext"));
        }
        return parent instanceof JSBreakStatement || parent instanceof JSContinueStatement || parent instanceof JSLiteralExpression || parent instanceof JSParameter || parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof XmlAttribute || parent instanceof XmlAttributeValue || parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == context || parent instanceof TypeScriptModule && ((TypeScriptModule)parent).getNameIdentifier() == context || JSTokenTypes.STRING_LITERALS.contains(context.getNode().getElementType()) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiComment.class}) != null || PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSAttribute.class}) != null || parent instanceof JSReferenceExpression && JSResolveUtil.isSelfReference(parent);
    }

    private static boolean isES6ShortHandedProperty(PsiElement parent, PsiElement grandParent) {
        return grandParent instanceof JSProperty && ((JSProperty)grandParent).getNameIdentifier() == parent;
    }

    private static boolean isEmbeddedContentExpression(PsiElement grandParent) {
        ASTNode grandParentNode;
        return grandParent instanceof JSEmbeddedContent && (grandParentNode = grandParent.getNode()) != null && grandParentNode.getElementType() == JSElementTypes.EMBEDDED_EXPRESSION;
    }

    private static void appendCaseKeywords(List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "case");
        JSKeywordsCompletionProvider.appendKeywords(keywords, JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "default");
    }

    public static void appendKeywords(List<Trinity<String, JSLookupPriority, Boolean>> keywords, @NotNull JSLookupPriority priority, boolean appendSpace, String ... names) {
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/completion/JSKeywordsCompletionProvider", "appendKeywords"));
        }
        for (String name : names) {
            keywords.add((Trinity<String, JSLookupPriority, Boolean>)Trinity.create((Object)name, (Object)((Object)priority), (Object)appendSpace));
        }
    }

    private static LookupElement[] createKeywordItems(List<Trinity<String, JSLookupPriority, Boolean>> keywords) {
        THashMap keywordsMap = new THashMap();
        for (Trinity<String, JSLookupPriority, Boolean> keyword : keywords) {
            Pair oldKeywordValue = (Pair)keywordsMap.get(keyword.first);
            if (oldKeywordValue != null && ((JSLookupPriority)((Object)oldKeywordValue.first)).compareTo((Enum)keyword.second) >= 0) continue;
            keywordsMap.put(keyword.first, Pair.create((Object)keyword.second, (Object)keyword.third));
        }
        LookupElement[] result = new LookupElement[keywordsMap.size()];
        int i = 0;
        for (Map.Entry entry : keywordsMap.entrySet()) {
            String option = (String)entry.getKey();
            LookupElementBuilder element = LookupElementBuilder.create((String)option).withBoldness(true).withInsertHandler("function".equals(option) ? FUNCTION_KEYWORD_INSERT_HANDLER : ((Boolean)((Pair)entry.getValue()).second != false ? AddSpaceInsertHandler.INSTANCE : JSInsertHandler.DEFAULT));
            LookupElement item = JSCompletionUtil.withJSLookupPriority((LookupElement)element, (JSLookupPriority)((Object)((Pair)entry.getValue()).first));
            result[i++] = item;
        }
        return result;
    }

    static {
        FUNCTION_TEMPLATE.addVariable("NAME", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_TEMPLATE.setToReformat(true);
        FUNCTION_EXPRESSION_TEMPLATE.addVariable("PARAMS", (Expression)new EmptyNode(), true);
        FUNCTION_EXPRESSION_TEMPLATE.setToReformat(true);
        FUNCTION_KEYWORD_INSERT_HANDLER = new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                PsiFile file = context.getFile();
                PsiElement at = file.findElementAt(context.getStartOffset());
                if (at == null || at.getNode().getElementType() != JSTokenTypes.FUNCTION_KEYWORD) {
                    return;
                }
                PsiElement parent = at.getParent();
                Template template = null;
                if (parent instanceof JSFunction && !(at.getNextSibling() instanceof JSParameterList)) {
                    if (parent instanceof JSFunctionExpression) {
                        template = FUNCTION_EXPRESSION_TEMPLATE;
                    } else if (DialectDetector.isJavaScript((PsiElement)file)) {
                        template = FUNCTION_TEMPLATE;
                    } else {
                        EditorModificationUtil.insertStringAtCaret((Editor)context.getEditor(), (String)" ");
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                    }
                }
                if (template != null) {
                    TemplateManager.getInstance((Project)context.getProject()).startTemplate(context.getEditor(), template);
                    context.setAddCompletionChar(false);
                }
            }
        };
    }
}

