/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class JSQualifiedElementNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement scope;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        assert (parent instanceof JSQualifiedNamedElement) : "must be filtered in JSPatternBasedCompletionContributor";
        if (parent instanceof JSPackageStatement) {
            return;
        }
        if (parent instanceof TypeScriptModule) {
            String ns;
            PsiElement grandParent = parent.getParent();
            String string = ns = grandParent instanceof TypeScriptModule ? ((TypeScriptModule)grandParent).getQualifiedName() : "";
            if (ns != null) {
                Collection<JSPsiElementBase> children = TypeScriptClassResolver.getInstance().findChildren(ns, (PsiElement)parent.getContainingFile());
                HashSet added = ContainerUtil.newHashSet();
                for (JSPsiElementBase child : children) {
                    if (!(child instanceof TypeScriptModule) || !added.add(child.getName())) continue;
                    LookupItem<Object> item = JSLookupUtilImpl.createPrioritizedLookupItem((PsiElement)child, child.getName(), JSLookupPriority.SMART_PRIORITY, true, false);
                    assert (item != null);
                    result.addElement(item);
                }
            }
        }
        if ((scope = JSPsiImplUtils.getExecutionScope(parent)) != null && !parameters.isAutoPopup()) {
            final THashSet unresolvedReferences = new THashSet();
            scope.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    super.visitJSReferenceExpression(node);
                    if (node.getQualifier() == null && (node = (JSReferenceExpression)CompletionUtil.getOriginalOrSelf((PsiElement)node)).multiResolve(false).length == 0) {
                        unresolvedReferences.add((Object)node.getReferenceName());
                    }
                }

                public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider$1", "visitJSFunctionExpression"));
                    }
                }

                public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider$1", "visitJSFunctionDeclaration"));
                    }
                }
            });
            unresolvedReferences.forEach(s -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider", "lambda$addCompletions$0"));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)s));
            });
        }
    }
}

