/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JSXHarmonyLanguageDialect
extends JSLanguageDialect {
    public static final DialectOptionHolder DIALECT_OPTION_HOLDER = DialectOptionHolder.JSX;

    public JSXHarmonyLanguageDialect() {
        super("JSX Harmony", DIALECT_OPTION_HOLDER, JavaScriptSupportLoader.ECMA_SCRIPT_6, "text/jsx", "text/babel");
    }

    public static boolean isReactComponent(JSExpression expression) {
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)expression;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "React", "createClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "createReactClass");
    }

    public static boolean areReferencesResolvedOrEmpty(@NotNull JSXmlLiteralExpressionImpl expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/dialects/JSXHarmonyLanguageDialect", "areReferencesResolvedOrEmpty"));
        }
        PsiReference[] references = expression.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (references.length == 0) {
            return true;
        }
        ArrayList resolved = ContainerUtil.newArrayList();
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                Collection<PsiElement> elements = JSResolveResult.toElements(results);
                resolved.addAll(elements.stream().filter(el -> {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/dialects/JSXHarmonyLanguageDialect", "lambda$areReferencesResolvedOrEmpty$0"));
                    }
                    return !el.equals((Object)expression);
                }).collect(Collectors.toList()));
                continue;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null || resolve.equals((Object)expression)) continue;
            resolved.add(resolve);
        }
        return !resolved.isEmpty();
    }

    @Override
    public String getFileExtension() {
        return "js";
    }

    @Override
    public JavaScriptParser<?, ?, ?, ?> createParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/dialects/JSXHarmonyLanguageDialect", "createParser"));
        }
        return new ES6Parser(this, builder);
    }
}

