/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.scratch.JSScratchFileInfoProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveScopeProvider
extends JSElementResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "getResolveScope"));
        }
        FileType type = file.getFileType();
        if (!this.isApplicable(file) && !TypeScriptResolveScopeProvider.isTypeScriptScratchFile(file, project, type)) {
            return null;
        }
        Set<VirtualFile> predefinedLibraryFiles = TypeScriptLibraryProvider.getPredefineLibraries(project, file);
        if (predefinedLibraryFiles.contains(file)) {
            return GlobalSearchScope.filesScope((Project)project, predefinedLibraryFiles);
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file);
        if (module == null) {
            GlobalSearchScope resultScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)this.getProjectScopeIncludingPredefines(project), (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
            return resultScope.uniteWith(GlobalSearchScope.filesScope((Project)project, predefinedLibraryFiles));
        }
        GlobalSearchScope scopeExcludingJsLibs = (GlobalSearchScope)((CachedValue)JSResolveUtil.ourScopeCache.get((UserDataHolder)module, null)).getValue();
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        Set files = mappings.getLibraryFilesFor(file);
        files.addAll(predefinedLibraryFiles);
        files.removeAll(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
        GlobalSearchScope filesScope = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, (Set)files);
        scopeExcludingJsLibs = scopeExcludingJsLibs.uniteWith(filesScope);
        scopeExcludingJsLibs = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scopeExcludingJsLibs, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        return scopeExcludingJsLibs;
    }

    private static boolean isTypeScriptScratchFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isTypeScriptScratchFile"));
        }
        return type instanceof LanguageFileType && JSScratchFileInfoProvider.Provider.isScratchForLanguage(project, file, type, ((LanguageFileType)type).getLanguage());
    }

    @Override
    protected boolean isApplicable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider", "isApplicable"));
        }
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
    }
}

