/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSEnterInEmptyArrayHandler
extends EnterBetweenBracesHandler {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/editing/JSEnterInEmptyArrayHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/editing/JSEnterInEmptyArrayHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffsetRef", "com/intellij/lang/javascript/editing/JSEnterInEmptyArrayHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/lang/javascript/editing/JSEnterInEmptyArrayHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/javascript/editing/JSEnterInEmptyArrayHandler", "preprocessEnter"));
        }
        if (!JSEnterInEmptyArrayHandler.isInJavaScript(file, (Integer)caretOffsetRef.get())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.preprocessEnter(file, editor, caretOffsetRef, caretAdvance, dataContext, originalHandler);
    }

    protected boolean isBracePair(char c1, char c2) {
        return c1 == '[' && c2 == ']';
    }

    private static boolean isInJavaScript(PsiFile file, int caretOffset) {
        PsiElement currElement;
        if (JSUtils.isJavaScriptFile(file)) {
            return true;
        }
        return caretOffset >= 0 && caretOffset < file.getTextLength() && (currElement = file.findElementAt(caretOffset)) != null && currElement.getLanguage().is((Language)JavascriptLanguage.INSTANCE);
    }
}

