/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.flex.ScopedImportSet;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiScopedImportSet
extends ScopedImportSet {
    private static final Key<CachedValue<Map<String, Object>>> ourImportListCache = Key.create((String)"js.import.list.cache");
    private static final ImportListDataCache myImportListCache = new ImportListDataCache();

    @Override
    @NotNull
    protected Map<String, Object> getUpToDateMap(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/flex/PsiScopedImportSet", "getUpToDateMap"));
        }
        Map map = (Map)((CachedValue)myImportListCache.get(ourImportListCache, (UserDataHolder)scope, null)).getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/PsiScopedImportSet", "getUpToDateMap"));
        }
        return map;
    }

    private static class ImportListDataCache
    extends UserDataCache<CachedValue<Map<String, Object>>, PsiElement, Object> {
        private ImportListDataCache() {
        }

        protected final CachedValue<Map<String, Object>> compute(PsiElement owner, Object o) {
            return CachedValuesManager.getManager((Project)owner.getProject()).createCachedValue(() -> {
                THashMap result = new THashMap();
                ImportListDataCache.collect((Map<String, Object>)result, owner, null);
                return new CachedValueProvider.Result((Object)result, new Object[]{owner});
            }, false);
        }

        private static void collect(Map<String, Object> result, PsiElement owner, Set<PsiFile> visitedIncludes) {
            Object[] children = PsiElement.EMPTY_ARRAY;
            if (owner instanceof JSIncludeDirective) {
                PsiFile file = ((JSIncludeDirective)owner).resolveFile();
                if (!(file == null || visitedIncludes != null && visitedIncludes.contains(file))) {
                    if (visitedIncludes == null) {
                        visitedIncludes = new THashSet();
                    }
                    visitedIncludes.add((PsiFile)file);
                    children = JSResolveUtil.getSourceElements((PsiElement)file);
                }
            } else {
                children = owner instanceof JSFile || owner instanceof JSStubElementImpl ? JSResolveUtil.getSourceElements(owner) : owner.getChildren();
            }
            for (PsiElement c : children) {
                if (c instanceof JSImportStatement) {
                    JSImportStatement s = (JSImportStatement)c;
                    if (s.getImportText() == null) continue;
                    ScopedImportSet.appendToMap(result, s);
                    continue;
                }
                if (c instanceof JSPackageStatement || c instanceof JSFunction) continue;
                ImportListDataCache.collect(result, c, (Set<PsiFile>)visitedIncludes);
            }
        }
    }
}

