/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import icons.JavaScriptPsiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBackedJSClassImpl
extends ActionScriptClassBase<JSClassStub<?>>
implements XmlBackedJSClass {
    @NonNls
    public static final String COMPONENT_TAG_NAME = "Component";
    @NonNls
    public static final String CLASS_NAME_ATTRIBUTE_NAME = "className";
    @NonNls
    public static final String SCRIPT_TAG_NAME = "Script";
    protected static final String CDATA_START = "<![CDATA[";
    protected static final String CDATA_END = "]]>";
    protected static final String IMPLEMENTS_ATTRIBUTE = "implements";
    public static final String SOURCE_ATTR = "source";
    protected volatile JSReferenceList myExtendsList;
    private volatile JSAttributeList myAttributeList;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.flex.XmlBackedJSClassImpl");
    private static final Key<CachedValue<JSFile[]>> CACHED_SCRIPTS_KEY = Key.create((String)"cached.scripts");
    private static final Key<CachedValue<Map<String, String>>> OUR_CACHED_SHORT_COMPONENTS_REF_KEY = Key.create((String)"cached.component.refs");
    private static final UserDataCache<CachedValue<JSFile[]>, XmlTag, Object> ourCachedScripts = new UserDataCache<CachedValue<JSFile[]>, XmlTag, Object>(){

        protected CachedValue<JSFile[]> compute(XmlTag tag, Object p) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue(() -> {
                final ArrayList injectedFiles = new ArrayList(2);
                new InjectedScriptsVisitor(tag, XmlBackedJSClassProvider.forFile((XmlFile)((XmlFile)tag.getContainingFile())), false, false, new XmlBackedJSClass.InjectedFileVisitor(){

                    public void visit(XmlTag rootTag, JSFile file) {
                        injectedFiles.add(file);
                    }
                }, true).go();
                return new CachedValueProvider.Result((Object)injectedFiles.toArray(new JSFile[injectedFiles.size()]), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
        }
    };
    private static final UserDataCache<CachedValue<Map<String, String>>, XmlTag, Object> myCachedComponentImportsCache = new UserDataCache<CachedValue<Map<String, String>>, XmlTag, Object>(){

        protected CachedValue<Map<String, String>> compute(final XmlTag t, Object p) {
            return CachedValuesManager.getManager((Project)t.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, String>>(){

                public CachedValueProvider.Result<Map<String, String>> compute() {
                    THashMap cachedComponentImports = new THashMap();
                    HashSet<PsiFile> dependencies = new HashSet<PsiFile>();
                    dependencies.add(t.getContainingFile());
                    t.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)cachedComponentImports, dependencies){
                        final /* synthetic */ Map val$cachedComponentImports;
                        final /* synthetic */ Set val$dependencies;
                        {
                            this.val$cachedComponentImports = map;
                            this.val$dependencies = set;
                        }

                        public void visitXmlTag(XmlTag tag) {
                            if (tag != t && XmlBackedJSClassImpl.isComponentTag(tag)) {
                                return;
                            }
                            XmlElementDescriptor descriptor = tag.getDescriptor();
                            if (descriptor != null) {
                                PsiElement declaration = descriptor.getDeclaration();
                                if (declaration instanceof XmlFile) {
                                    declaration = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)declaration);
                                }
                                if (declaration instanceof JSClass) {
                                    JSClass jsClass = (JSClass)declaration;
                                    this.val$cachedComponentImports.put(jsClass.getName(), jsClass.getQualifiedName());
                                    this.val$dependencies.add(declaration.getContainingFile());
                                }
                            }
                            super.visitXmlTag(tag);
                        }
                    });
                    return new CachedValueProvider.Result((Object)cachedComponentImports, dependencies.toArray());
                }
            }, false);
        }
    };

    public XmlBackedJSClassImpl(XmlTag tag) {
        super(tag.getNode());
    }

    @Override
    @Nullable
    public JSReferenceList getExtendsList() {
        JSReferenceList refList = this.myExtendsList;
        if (refList == null && (refList = this.createReferenceList(this.getSuperClassName())) != null) {
            refList.getParent().putUserData(JSResolveUtil.contextKey, (Object)this);
            this.myExtendsList = refList;
        }
        return refList;
    }

    protected String getSuperClassName() {
        return this.getParent().getLocalName();
    }

    @Nullable
    protected JSReferenceList createReferenceList(String s) {
        if (s == null) {
            return null;
        }
        String text = "class C extends " + s + " {}";
        JSClass element = this.createDummyClass(text);
        return element != null ? element.getExtendsList() : null;
    }

    private JSClass createDummyClass(String text) {
        PsiElement psi = JSChangeUtil.createJSTreeFromText(this.getProject(), text, this.getClassLanguage()).getPsi();
        if (!(psi instanceof JSClass)) {
            return null;
        }
        JSClass element = (JSClass)psi;
        element.putUserData(JSResolveUtil.contextKey, (Object)this);
        element.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)this);
        return element;
    }

    protected JSLanguageDialect getClassLanguage() {
        return JavaScriptSupportLoader.ECMA_SCRIPT_6;
    }

    @Override
    protected Icon getBaseIcon() {
        return JavaScriptPsiIcons.Classes.XmlBackedClass;
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    @Nullable
    public JSReferenceList getImplementsList() {
        return null;
    }

    public static boolean isImplementsAttribute(JSFile file) {
        PsiElement context = file.getContext();
        if (context instanceof XmlAttributeValue && IMPLEMENTS_ATTRIBUTE.equals(((XmlAttribute)context.getParent()).getName())) {
            return true;
        }
        return file.getUserData(JSResolveUtil.contextKey) instanceof XmlBackedJSClassImpl;
    }

    public void addToImplementsList(String refText) {
        throw new UnsupportedOperationException();
    }

    public void removeFromImplementsList(String refText) {
        throw new UnsupportedOperationException();
    }

    public PsiElement getNavigationElement() {
        return this.getParent();
    }

    @Override
    public String getName() {
        PsiFile psi = this.getParent().getContainingFile().getOriginalFile();
        return FileUtil.getNameWithoutExtension((String)psi.getName());
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        PsiFile containingFile = this.getNode().getPsi().getContainingFile();
        String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getOriginalFile().getVirtualFile(), containingFile.getProject());
        if (expectedPackageNameFromFile != null && expectedPackageNameFromFile.length() > 0) {
            return JSQualifiedNameImpl.fromQualifiedName(expectedPackageNameFromFile);
        }
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return JSPsiImplUtils.isDeprecatedFromAttribute((JSAttributeListOwner)this);
    }

    @Override
    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getParent().getNode();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "setName"));
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        JSPsiImplUtils.updateFileName(this, name, this.getName());
        return null;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        JSAttributeList attrList = this.myAttributeList;
        if (attrList == null) {
            JSClass element = this.createDummyClass("public class C {}");
            this.myAttributeList = attrList = element != null ? element.getAttributeList() : null;
        }
        return attrList;
    }

    public boolean processInjectedFiles(Processor<JSFile> processor) {
        for (JSFile file : (JSFile[])((CachedValue)ourCachedScripts.get(CACHED_SCRIPTS_KEY, (UserDataHolder)this.getParent(), null)).getValue()) {
            if (!file.isValid() && ApplicationManager.getApplication().isUnitTestMode()) {
                ourCachedScripts.clear(CACHED_SCRIPTS_KEY, (UserDataHolder)this.getParent());
                return this.processInjectedFiles(processor);
            }
            if (processor.process((Object)file)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processMembers(PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        boolean b = this.processInjectedFiles((Processor<JSFile>)((Processor)jsFile -> {
            ResolveState state = ResolveState.initial().put(PROCESS_XML_BACKED_CLASS_MEMBERS_HINT, (Object)Boolean.TRUE);
            return jsFile.processDeclarations(processor, state, null, place);
        }));
        if (!b) {
            return false;
        }
        if (place instanceof JSReferenceExpression && place.getParent() instanceof JSCallExpression) {
            return true;
        }
        this.processImplicitMembers(processor);
        PsiFile xmlFile = this.getParent().getContainingFile();
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> implicitElements = JSIndexContent.get(xmlFile).getImplicitElements();
        for (JSImplicitElementsIndex.JSElementProxy jsElementProxy : ContainerUtil.concat(implicitElements.values())) {
            PsiElement elementAtOffset;
            XmlAttributeValue xmlAttributeValue;
            JSOffsetBasedImplicitElement implicitElement = jsElementProxy.toOffsetBasedImplicitElement(xmlFile);
            if (implicitElement.getType() != JSImplicitElement.Type.Tag || (xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)(elementAtOffset = implicitElement.getElementAtOffset()), XmlAttributeValue.class, (boolean)false)) == null || !this.canResolveTo((XmlElement)xmlAttributeValue) || processor.execute((PsiElement)implicitElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    protected void processImplicitMembers(PsiScopeProcessor processor) {
    }

    public boolean processOuterDeclarations(PsiScopeProcessor processor) {
        return true;
    }

    public void visitInjectedFiles(XmlBackedJSClass.InjectedFileVisitor visitor) {
        new InjectedScriptsVisitor(XmlBackedJSClassFactory.getRootTag((XmlFile)this.getContainingFile()), null, true, true, visitor, true).go();
    }

    protected boolean canResolveTo(XmlElement element) {
        return true;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "processDeclarations"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "processDeclarations"));
        }
        boolean b = super.processDeclarations(processor, substitutor, lastParent, place);
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this.getParent());
        if (b && lastParent == this && JSResolveUtil.shouldProcessImports(place, processor)) {
            b = JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place);
            if (!b) {
                return false;
            }
            b = this.doImportFromScripts(processor, place);
        }
        return b;
    }

    public boolean doImportFromScripts(PsiScopeProcessor processor, PsiElement place) {
        boolean notResolvingTypeViaImport;
        PsiElement context = place.getContainingFile().getContext();
        if (context instanceof XmlText) {
            context = context.getParent();
        }
        boolean bl = notResolvingTypeViaImport = !(place instanceof JSFile);
        if (context instanceof XmlAttributeValue && JSResolveUtil.getElementThatShouldBeQualified(place, null) == null || context instanceof XmlTag && (!SCRIPT_TAG_NAME.equals(((XmlTag)context).getLocalName()) || notResolvingTypeViaImport) || context == null) {
            boolean useImports = JSResolveUtil.shouldProcessImports(place, processor);
            Ref adequatePlace = new Ref((Object)false);
            if (processor instanceof ResolveProcessor && ((ResolveProcessor)processor).getName() != null && !this.resolveViaImplicitImports((ResolveProcessor)processor)) {
                return false;
            }
            boolean b = this.processInjectedFiles((Processor<JSFile>)((Processor)file -> {
                if (JSImportHandlingUtil.isAdequatePlaceForImport((PsiNamedElement)file, place, processor)) {
                    JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)file).getImportHandler();
                    if (useImports && !importHandler.importClass(processor, (PsiNamedElement)file)) {
                        return false;
                    }
                    adequatePlace.set((Object)true);
                }
                return true;
            }));
            if (!b) {
                return false;
            }
            if (((Boolean)adequatePlace.get()).booleanValue() && processor instanceof ResolveProcessor && !this.processComponentNames((ResolveProcessor)processor)) {
                return false;
            }
        }
        return !(processor instanceof ResolveProcessor) || !JSResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) || !notResolvingTypeViaImport || JSResolveUtil.processGlobalThings((ResolveProcessor)processor, ResolveState.initial(), place, (PsiElement)this);
    }

    protected boolean resolveViaImplicitImports(ResolveProcessor processor) {
        return true;
    }

    public boolean processComponentNames(ResolveProcessor processor) {
        block5: {
            Map value;
            block3: {
                PsiElement clazz;
                block4: {
                    String s = processor.getName();
                    value = (Map)((CachedValue)myCachedComponentImportsCache.get(OUR_CACHED_SHORT_COMPONENTS_REF_KEY, (UserDataHolder)this.getParent(), null)).getValue();
                    if (s == null) break block3;
                    String qName = (String)value.get(s);
                    if (qName == null) break block4;
                    PsiElement clazz2 = JSDialectSpecificHandlersFactory.forLanguage(this.getClassLanguage()).getClassResolver().findClassByQName(qName, (PsiElement)this);
                    if (clazz2 != null) {
                        return processor.execute(clazz2, ResolveState.initial());
                    }
                    break block5;
                }
                String qualifiedNameToImport = processor.getQualifiedNameToImport();
                if (qualifiedNameToImport == null || (clazz = JSDialectSpecificHandlersFactory.forLanguage(this.getClassLanguage()).getClassResolver().findClassByQName(qualifiedNameToImport, (PsiElement)this)) == null) break block5;
                for (String componentQName : value.values()) {
                    if (!StringUtil.getPackageName((String)componentQName).equals(StringUtil.getPackageName((String)qualifiedNameToImport)) || processor.execute(clazz, ResolveState.initial())) continue;
                    return false;
                }
                break block5;
            }
            for (String qName : value.values()) {
                PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)this).getClassResolver().findClassByQName(qName, (PsiElement)this);
                if (clazz == null || processor.execute(clazz, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return this.getNode().getPsi().isValid();
    }

    public static Collection<JSClass> getClasses(XmlFile file) {
        XmlTag rootTag = XmlBackedJSClassFactory.getRootTag(file);
        if (rootTag == null) {
            return Collections.emptyList();
        }
        ArrayList<JSClass> result = new ArrayList<JSClass>();
        result.add((JSClass)XmlBackedJSClassFactory.getInstance().getXmlBackedClass(rootTag));
        XmlBackedJSClassProvider provider = XmlBackedJSClassProvider.forFile((XmlFile)file);
        if (provider != null) {
            result.addAll(provider.getChildClasses(file));
        }
        return result;
    }

    @Nullable
    public static XmlBackedJSClass getContainingComponent(XmlElement element) {
        if (element instanceof XmlTag && XmlBackedJSClassImpl.isComponentTag((XmlTag)element)) {
            XmlTag[] subtags = ((XmlTag)element).getSubTags();
            return subtags.length > 0 ? XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]) : null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parentTag != null) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)parentTag);
        }
        if (element instanceof XmlFile) {
            XmlDocument document = ((XmlFile)element).getDocument();
            XmlTag xmlTag = element = document != null ? document.getRootTag() : null;
        }
        if (!(element instanceof XmlTag)) {
            return null;
        }
        return XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)element);
    }

    public XmlTag getParent() {
        return (XmlTag)this.getNode().getPsi();
    }

    public boolean isPhysical() {
        return false;
    }

    public boolean isEquivalentTo(PsiElement element2) {
        return this == element2 || element2 == this.getContainingFile().getOriginalFile() || element2 instanceof XmlBackedJSClassImpl && this.getContainingFile().getOriginalFile() == element2.getContainingFile().getOriginalFile();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        JSFile jsFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "add"));
        }
        if ((element instanceof JSFunction || element instanceof JSVarStatement) && (jsFile = this.createOrGetFirstScriptTag()) != null) {
            String text;
            PsiElement child = jsFile.getLastChild();
            if (child instanceof PsiWhiteSpace && (text = child.getText()).indexOf(CDATA_END) != -1) {
                int cdataAt = 0;
                String marker = CDATA_START;
                cdataAt = text.indexOf(marker);
                if (cdataAt == -1) {
                    element = jsFile.addBefore(element, child);
                } else {
                    int markerEnd = cdataAt + marker.length();
                    ASTNode fromText = JSChangeUtil.createJSTreeFromText(this.getProject(), text.substring(0, markerEnd) + element.getText() + text.substring(markerEnd), (JSLanguageDialect)element.getContainingFile().getLanguage());
                    jsFile.getNode().replaceAllChildrenToChildrenOf(fromText.getTreeParent());
                    element = PsiTreeUtil.getParentOfType((PsiElement)jsFile.findElementAt(markerEnd + 1), element.getClass());
                }
            } else {
                element = jsFile.add(element);
            }
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement((ASTNode)jsFile.getNode(), element.getNode());
            return element;
        }
        return super.add(element);
    }

    public JSFile createScriptTag() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "addBefore"));
        }
        if (anchor == null) {
            return this.add(element);
        }
        return anchor.getParent().addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "addAfter"));
        }
        if (anchor == null) {
            return this.add(element);
        }
        return anchor.getParent().addAfter(element, anchor);
    }

    @Nullable
    public JSFile findFirstScriptTag() {
        Ref result = new Ref();
        this.processInjectedFiles((Processor<JSFile>)((Processor)jsFile -> {
            result.set(jsFile);
            return false;
        }));
        return (JSFile)result.get();
    }

    public JSFile createOrGetFirstScriptTag() throws IncorrectOperationException {
        JSFile jsFile = this.findFirstScriptTag();
        if (jsFile == null) {
            jsFile = this.createScriptTag();
        }
        return jsFile;
    }

    public static boolean isComponentTag(XmlTag tag) {
        return COMPONENT_TAG_NAME.equals(tag.getLocalName()) && JavaScriptSupportLoader.isLanguageNamespace(tag.getNamespace()) && !(tag.getParent() instanceof XmlDocument);
    }

    public static boolean isInsideTag(XmlTag tag, Condition<XmlTag> tagCondition) {
        if (tag == null) {
            return false;
        }
        XmlTag parent = tag;
        while ((parent = parent.getParentTag()) != null) {
            if (!tagCondition.value((Object)parent)) continue;
            return true;
        }
        return false;
    }

    public static void syncInjectedFiles(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "syncInjectedFiles"));
        }
        XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getXmlBackedClass(file);
        if (jsClass != null) {
            jsClass.visitInjectedFiles(new XmlBackedJSClass.InjectedFileVisitor(){

                public void visit(XmlTag rootTag, JSFile file) {
                }
            });
        }
    }

    public static void getLanguagesToInjectStatic(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "getLanguagesToInjectStatic"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl", "getLanguagesToInjectStatic"));
        }
        for (MultiHostInjector injector : (MultiHostInjector[])Extensions.getExtensions((ExtensionPointName)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, (AreaInstance)host.getProject())) {
            if (!(injector instanceof JSTargetedInjector)) continue;
            injector.getLanguagesToInject(registrar, host);
        }
    }

    public static class InjectedScriptsVisitor
    implements PsiElementProcessor {
        private final XmlBackedJSClassProvider myProvider;
        private final boolean myVisitAttributes;
        private final XmlTag myRootTag;
        private final boolean myVisitInnerComponents;
        private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
        private final Processor<XmlTag> myXmlTagProcessor;
        private final boolean myIsPhysical;

        public InjectedScriptsVisitor(XmlTag rootTag, @Nullable XmlBackedJSClassProvider provider, boolean visitAttributes, boolean visitInnerComponents, XmlBackedJSClass.InjectedFileVisitor visitor, Processor<XmlTag> processor, boolean physical) {
            this.myProvider = provider;
            this.myVisitAttributes = visitAttributes;
            this.myRootTag = rootTag;
            this.myVisitInnerComponents = visitInnerComponents;
            this.myVisitor = visitor;
            this.myXmlTagProcessor = processor;
            this.myIsPhysical = physical;
        }

        public InjectedScriptsVisitor(XmlTag rootTag, @Nullable XmlBackedJSClassProvider provider, boolean visitAttributes, boolean visitInnerComponents, XmlBackedJSClass.InjectedFileVisitor visitor, boolean physical) {
            this(rootTag, provider, visitAttributes, visitInnerComponents, visitor, new InjectingProcessor(visitor, rootTag, physical), physical);
        }

        public void go() {
            this.execute((PsiElement)this.myRootTag);
        }

        public boolean execute(@NotNull PsiElement element) {
            XmlAttributeValue value;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor", "execute"));
            }
            if (element instanceof XmlTag) {
                XmlTag tag = (XmlTag)element;
                if (this.myProvider == null || this.myProvider.isScriptTag(tag)) {
                    XmlAttribute src = tag.getAttribute(XmlBackedJSClassImpl.SOURCE_ATTR);
                    if (src != null) {
                        PsiFile file;
                        if (this.myIsPhysical && (file = FileReferenceUtil.findFile((PsiElement)src.getValueElement())) instanceof JSFile) {
                            file.putUserData(JSResolveUtil.contextKey, (Object)tag);
                            this.myVisitor.visit(this.myRootTag, (JSFile)file);
                        }
                    } else {
                        this.myXmlTagProcessor.process((Object)tag);
                    }
                }
                if (XmlBackedJSClassImpl.isComponentTag(tag)) {
                    if (this.myVisitInnerComponents) {
                        new InjectedScriptsVisitor(tag, this.myProvider, this.myVisitAttributes, true, this.myVisitor, this.myXmlTagProcessor, this.myIsPhysical).goFromChildren();
                    }
                } else {
                    tag.processElements((PsiElementProcessor)this, null);
                }
            }
            if (this.myVisitAttributes && element instanceof XmlAttribute && (value = ((XmlAttribute)element).getValueElement()) != null) {
                if (this.myIsPhysical) {
                    InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)value.getProject());
                    if (manager != null) {
                        manager.enumerate((PsiElement)value, (injectedPsi, places) -> {
                            if (((PsiLanguageInjectionHost.Shred)places.get(0)).getHost() instanceof XmlAttributeValue && injectedPsi instanceof JSFile) {
                                this.myVisitor.visit(this.myRootTag, (JSFile)injectedPsi);
                            }
                        });
                    }
                } else {
                    XmlBackedJSClassImpl.getLanguagesToInjectStatic(new MyRegistrar(this.myRootTag, this.myVisitor), (PsiElement)value);
                }
            }
            return true;
        }

        private void goFromChildren() {
            this.myRootTag.processElements((PsiElementProcessor)this, null);
        }

        public static class MyRegistrar
        implements MultiHostRegistrar {
            private boolean myIsECMAScript;
            private final XmlTag myRootTag;
            private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
            private StringBuilder myOutChars;
            private PsiLanguageInjectionHost myHost;

            public MyRegistrar(XmlTag rootTag, XmlBackedJSClass.InjectedFileVisitor visitor) {
                this.myRootTag = rootTag;
                this.myVisitor = visitor;
            }

            @NotNull
            public MultiHostRegistrar startInjecting(@NotNull Language language) {
                if (language == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "startInjecting"));
                }
                this.myIsECMAScript = language.isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                this.myOutChars = new StringBuilder();
                MyRegistrar myRegistrar = this;
                if (myRegistrar == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "startInjecting"));
                }
                return myRegistrar;
            }

            @NotNull
            public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
                if (host == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "addPlace"));
                }
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "addPlace"));
                }
                this.myHost = host;
                if (!this.myIsECMAScript) {
                    MyRegistrar myRegistrar = this;
                    if (myRegistrar == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "addPlace"));
                    }
                    return myRegistrar;
                }
                TextRange hostTextRange = host.getTextRange();
                if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
                    throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (suffix == null) {
                    suffix = "";
                }
                this.myOutChars.append(prefix);
                LiteralTextEscaper textEscaper = host.createLiteralTextEscaper();
                TextRange relevantRange = textEscaper.getRelevantTextRange().intersection(rangeInsideHost);
                if (relevantRange != null) {
                    textEscaper.decode(relevantRange, this.myOutChars);
                }
                this.myOutChars.append(suffix);
                MyRegistrar myRegistrar = this;
                if (myRegistrar == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar", "addPlace"));
                }
                return myRegistrar;
            }

            public void doneInjecting() {
                this.myIsECMAScript = false;
                if (StringUtil.isNotEmpty((String)this.myOutChars.toString())) {
                    ASTNode node = JSChangeUtil.createJSTreeFromText(this.myRootTag.getProject(), this.myOutChars.toString(), JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                    PsiFile file = node.getPsi().getContainingFile();
                    file.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, (Object)SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)this.myHost));
                    if (file instanceof JSFile) {
                        this.myVisitor.visit(this.myRootTag, (JSFile)file);
                    }
                }
            }
        }

        public static class InjectingProcessor
        implements Processor<XmlTag> {
            private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
            private final XmlTag myRootTag;
            private final boolean myPhysical;

            public InjectingProcessor(XmlBackedJSClass.InjectedFileVisitor visitor, XmlTag rootTag, boolean isPhysical) {
                this.myVisitor = visitor;
                this.myRootTag = rootTag;
                this.myPhysical = isPhysical;
            }

            public boolean process(XmlTag tag) {
                if (this.myPhysical) {
                    JSResolveUtil.processInjectedFileForTag(tag, new JSResolveUtil.JSInjectedFilesVisitor(){

                        @Override
                        protected void process(JSFile file) {
                            myVisitor.visit(myRootTag, file);
                        }
                    });
                } else {
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        if (!(child instanceof XmlText)) continue;
                        XmlBackedJSClassImpl.getLanguagesToInjectStatic(new MyRegistrar(this.myRootTag, this.myVisitor), (PsiElement)child);
                    }
                }
                return true;
            }
        }
    }
}

