/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigImpl;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigServiceImpl
implements FlowJSConfigService {
    public static final Logger LOGGER = Logger.getInstance(FlowJSServerService.class);
    @NotNull
    private final Project myProject;
    private static final Function<PsiFile, FlowJSConfig> MAP_TO_CONFIG = FlowJSConfigImpl::getConfig;
    @NotNull
    private final CachedValue<Collection<FlowJSConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Collection<FlowJSConfig>>> myConfigToFile;

    public FlowJSConfigServiceImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "<init>"));
        }
        this.myProject = project;
        CachedValueProvider configsProvider = () -> {
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                Object[] files = FilenameIndex.getFilesByName((Project)this.myProject, (String)".flowconfig", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
                FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this.myProject);
                HashSet configFiles = ContainerUtil.newHashSet();
                if (fileIndexFacade != null) {
                    for (Object file : files) {
                        if (!fileIndexFacade.isInContent(file.getVirtualFile())) continue;
                        configFiles.add(file);
                    }
                }
                files = configFiles.toArray(PsiFile.EMPTY_ARRAY);
                List configs = ContainerUtil.mapNotNull((Object[])files, MAP_TO_CONFIG);
                ArrayList depends = ContainerUtil.newArrayList((Object[])files);
                depends.add(JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER);
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
                return result;
            }
            finally {
                token.finish();
            }
        };
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myConfigToFile = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    @Override
    @NotNull
    public Collection<FlowJSConfig> getConfigOfFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigOfFile"));
        }
        ConcurrentMap fileConfigsIncludeCache = (ConcurrentMap)this.myConfigToFile.getValue();
        if (fileConfigsIncludeCache.containsKey(file)) {
            Collection collection = (Collection)fileConfigsIncludeCache.get(file);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigOfFile"));
            }
            return collection;
        }
        Collection<FlowJSConfig> configOfFile = this.getConfigOfFileImpl(file);
        fileConfigsIncludeCache.put(file, configOfFile);
        Collection<FlowJSConfig> collection = configOfFile;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigOfFile"));
        }
        return collection;
    }

    @NotNull
    private Collection<FlowJSConfig> getConfigOfFileImpl(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigOfFileImpl"));
        }
        Collection<FlowJSConfig> allConfigs = this.getConfigFiles();
        ArrayList configOfFile = ContainerUtil.newArrayList();
        allConfigs.forEach(config -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "lambda$getConfigOfFileImpl$2"));
            }
            if (config.isFileIncluded(file) && !config.isFileIgnored(file)) {
                configOfFile.add(config);
            }
        });
        ArrayList arrayList = configOfFile;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigOfFileImpl"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<FlowJSConfig> getConfigFiles() {
        Collection value = (Collection)this.myConfigs.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getConfigFiles"));
        }
        return collection;
    }

    @Override
    public boolean isAvailable() {
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings();
        return settings.isTypeCheckingEnabled() && !settings.getFlowExecutablePath().isEmpty();
    }

    @Override
    @Nullable
    public FlowJSConfig getNearestConfig(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getNearestConfig"));
        }
        Collection<FlowJSConfig> configCollection = this.getConfigOfFile(file);
        return FlowJSConfigServiceImpl.getNearestConfig(configCollection, file);
    }

    @Nullable
    private static FlowJSConfig getNearestConfig(@NotNull Collection<FlowJSConfig> configCollection, @NotNull VirtualFile file) {
        if (configCollection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configCollection", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getNearestConfig"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "getNearestConfig"));
        }
        Optional<FlowJSConfig> nearestConfig = configCollection.stream().min(Comparator.comparingInt(config -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSConfigServiceImpl", "lambda$getNearestConfig$3"));
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)config.getConfigDirectory());
            if (relativePath == null) {
                return Integer.MAX_VALUE;
            }
            return StringUtil.countChars((CharSequence)relativePath, (char)'/');
        }));
        return nearestConfig.orElse(null);
    }
}

