/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ImmutableList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSServerManager
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentMap<VirtualFile, AtomicNotNullLazyValue<FlowJSServerService>> myConfigDirToServer;
    @NotNull
    private final UniqueNameBuilder<VirtualFile> myUniqueNameBuilder;

    public FlowJSServerManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerManager", "<init>"));
        }
        this.myProject = project;
        this.myConfigDirToServer = new ConcurrentHashMap<VirtualFile, AtomicNotNullLazyValue<FlowJSServerService>>();
        this.myUniqueNameBuilder = new UniqueNameBuilder(project.getBasePath(), String.valueOf('/'), 30);
    }

    public static FlowJSServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flow/FlowJSServerManager", "getInstance"));
        }
        return (FlowJSServerManager)ServiceManager.getService((Project)project, FlowJSServerManager.class);
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerManager", "getService"));
        }
        return FlowJSServerManager.getInstance(file.getProject()).getServiceImpl(file);
    }

    @Nullable
    private FlowJSServerService getServiceImpl(@NotNull PsiFile file) {
        FlowJSServerService serverService;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSServerManager", "getServiceImpl"));
        }
        final Project project = file.getProject();
        if (!this.isFlowAvailable(true)) {
            return null;
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(project);
        if (configService == null) {
            return null;
        }
        final FlowJSConfig config = configService.getNearestConfig(file.getVirtualFile());
        if (config == null) {
            return null;
        }
        AtomicNotNullLazyValue<FlowJSServerService> newServerServiceLazy = new AtomicNotNullLazyValue<FlowJSServerService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected FlowJSServerService compute() {
                String shortPath;
                UniqueNameBuilder uniqueNameBuilder = FlowJSServerManager.this.myUniqueNameBuilder;
                synchronized (uniqueNameBuilder) {
                    VirtualFile configDirectory = config.getConfigDirectory();
                    String path = configDirectory.getPath();
                    if (path.equals(project.getBasePath())) {
                        path = "Console";
                    }
                    FlowJSServerManager.this.myUniqueNameBuilder.addPath((Object)configDirectory, path);
                    shortPath = FlowJSServerManager.this.myUniqueNameBuilder.getShortPath((Object)configDirectory);
                }
                FlowJSServerService service = new FlowJSServerService(config, project, shortPath);
                Disposer.register((Disposable)FlowJSServerManager.this, (Disposable)service);
                FlowJSServerService flowJSServerService = service;
                if (flowJSServerService == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerManager$1", "compute"));
                }
                return flowJSServerService;
            }
        };
        AtomicNotNullLazyValue<FlowJSServerService> serverServiceLazy = this.myConfigDirToServer.putIfAbsent(config.getConfigDirectory(), newServerServiceLazy);
        if (serverServiceLazy == null) {
            serverServiceLazy = newServerServiceLazy;
        }
        if (!(serverService = (FlowJSServerService)serverServiceLazy.getValue()).checkCanUseService()) {
            return null;
        }
        return serverService;
    }

    public boolean isFlowAvailable() {
        return this.isFlowAvailable(false);
    }

    private boolean isFlowAvailable(boolean reportToToolWindowIfNotAvailable) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return false;
        }
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings();
        if (!settings.isTypeCheckingEnabled()) {
            return false;
        }
        String flowPath = settings.getFlowExecutablePath();
        if (StringUtil.isEmpty((String)flowPath)) {
            return false;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(flowPath);
        if (virtualFile == null) {
            if (reportToToolWindowIfNotAvailable) {
                JSLanguageServiceToolWindowManager flowJSToolWindowProvider = FlowJSToolWindowProvider.getToolWindow(this.myProject);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (flowJSToolWindowProvider != null) {
                        ImmutableList<JSAnnotationError> results = JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.validation.message.flowjs.path", (Object[])new Object[0]));
                        flowJSToolWindowProvider.logProjectErrors(results, true);
                    }
                });
            }
            return false;
        }
        return true;
    }

    public void restartAll() {
    }

    @NotNull
    public Collection<FlowJSServerService> getAllServers() {
        Collection collection = this.myConfigDirToServer.values().stream().map(value -> (FlowJSServerService)value.getValue()).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSServerManager", "getAllServers"));
        }
        return collection;
    }

    public void dispose() {
        this.myConfigDirToServer.clear();
    }
}

