/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.html.HtmlQuotesFormatPreprocessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEnforceCodeStylePostProcessor
implements PostFormatProcessor {
    private static TokenSet possiblyAmbiguousTokens = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACKET, JSTokenTypes.LPAR, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.DIV, JSTokenTypes.BACKQUOTE});

    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processElement"));
        }
        return PostFormatProcessorUtil.processElement(source, JSEnforceCodeStylePostProcessor::processTextRange);
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile rootPsi, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
        if (rootPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPsi", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processText"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processText"));
        }
        TextRange textRange = PostFormatProcessorUtil.processText(rootPsi, range, JSEnforceCodeStylePostProcessor::processTextRange);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processText"));
        }
        return textRange;
    }

    @NotNull
    private static TextRange processTextRange(@NotNull PsiElement rootPsi, @NotNull TextRange range) {
        if (rootPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPsi", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
        }
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(rootPsi);
        if (dialect == null || !dialect.getOptionHolder().isJavaScript() && !dialect.getOptionHolder().isTypeScript && !dialect.getOptionHolder().isECMA4) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
            }
            return textRange;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)rootPsi.getProject());
        JSCodeStyleSettings languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        if (!(languageSettings.FORCE_QUOTE_STYlE || languageSettings.FORCE_SEMICOLON_STYLE || settings.HTML_ENFORCE_QUOTES || languageSettings.ENFORCE_TRAILING_COMMA != JSCodeStyleSettings.TrailingCommaOption.Keep)) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
            }
            return textRange;
        }
        MyVisitor visitor = new MyVisitor(rootPsi, range, settings, document, dialect);
        DocumentUtil.executeInBulk((Document)document, (boolean)true, () -> {
            if (rootPsi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPsi", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "lambda$processTextRange$0"));
            }
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = visitor.getResultRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "processTextRange"));
        }
        return textRange;
    }

    private static boolean isDestructuringRest(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "isDestructuringRest"));
        }
        return element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT_DOT_DOT})).length > 0;
    }

    private static boolean isSafeToDeleteSemicolon(@NotNull JSElement jsElement) {
        if (jsElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsElement", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor", "isSafeToDeleteSemicolon"));
        }
        if (!(jsElement instanceof JSStatement)) {
            return true;
        }
        JSStatement nextStatement = (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsElement, JSStatement.class);
        if (nextStatement == null) {
            return true;
        }
        PsiElement firstLeaf = PsiTreeUtil.getDeepestFirst((PsiElement)nextStatement);
        return !possiblyAmbiguousTokens.contains(firstLeaf.getNode().getElementType());
    }

    private static class MyVisitor
    extends JSRecursiveElementVisitor {
        private final CodeStyleSettings.QuoteStyle myHtmlQuoteStyle;
        private final boolean myEnforceHtmlQuotes;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private TextRange myOriginalRange;
        private JSCodeStyleSettings languageSettings;
        private Document myDocument;
        private final DialectOptionHolder myDialectOptionHolder;
        private HtmlQuotesFormatPreprocessor.HtmlQuotesConverter myQuotesConverter;

        public MyVisitor(@NotNull PsiElement context, @NotNull TextRange originalRange, @NotNull CodeStyleSettings settings, @NotNull Document document, @NotNull JSLanguageDialect languageDialect) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "<init>"));
            }
            if (originalRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalRange", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "<init>"));
            }
            if (languageDialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageDialect", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "<init>"));
            }
            this.myHtmlQuoteStyle = settings.HTML_QUOTE_STYLE;
            this.myEnforceHtmlQuotes = settings.HTML_ENFORCE_QUOTES;
            this.myOriginalRange = originalRange;
            this.myPostProcessorHelper = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
            this.myPostProcessorHelper.setResultTextRange(originalRange);
            this.languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(languageDialect));
            this.myQuotesConverter = new HtmlQuotesFormatPreprocessor.HtmlQuotesConverter(this.myHtmlQuoteStyle, context, this.myPostProcessorHelper);
            this.myDocument = document;
            this.myDialectOptionHolder = languageDialect.getOptionHolder();
        }

        public TextRange getResultRange() {
            return this.myPostProcessorHelper.getResultTextRange();
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            this.applyJavaScriptQuoteStyle(element);
            if (element instanceof XmlTag) {
                this.applyJSXQuoteStyle(element);
            }
        }

        public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
            super.visitES6ImportDeclaration(importDeclaration);
            this.applySemicolonStyle((JSElement)importDeclaration);
            this.applyTrailingCommaStyle((JSElement[])importDeclaration.getImportSpecifiers());
        }

        public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
            super.visitES6ExportDeclaration(exportDeclaration);
            this.applySemicolonStyle((JSElement)exportDeclaration);
            this.applyTrailingCommaStyle((JSElement[])exportDeclaration.getExportSpecifiers());
        }

        public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
            super.visitES6ExportDefaultAssignment(node);
            if (node.getExpression() instanceof JSClass || node.getExpression() instanceof JSFunction) {
                return;
            }
            this.applySemicolonStyle((JSElement)node);
        }

        public void visitJSStatement(JSStatement node) {
            super.visitJSStatement(node);
            PsiElement parent = node.getParent();
            if (JSUtils.isStatementUsuallyRequiringSemicolon(node) && !(parent instanceof TypeScriptEnum)) {
                this.applySemicolonStyle((JSElement)node);
            }
        }

        public void visitJSForStatement(JSForStatement node) {
            JSExpression update;
            JSExpression initialization;
            JSVarStatement varDeclaration = node.getVarDeclaration();
            if (varDeclaration != null) {
                for (JSVariable variable : varDeclaration.getVariables()) {
                    this.visitElement((PsiElement)variable);
                }
            }
            if ((initialization = node.getInitialization()) != null) {
                this.visitElement((PsiElement)initialization);
            }
            if ((update = node.getUpdate()) != null) {
                this.visitElement((PsiElement)update);
            }
            JSStatement body = node.getBody();
            this.visitElement((PsiElement)body);
        }

        public void visitJSForInStatement(JSForInStatement node) {
            JSExpression collectionExpression = node.getCollectionExpression();
            if (collectionExpression != null) {
                this.visitElement((PsiElement)collectionExpression);
            }
            this.visitElement((PsiElement)node.getBody());
        }

        public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
            super.visitJSArrayLiteralExpression(node);
            this.applyTrailingCommaStyle((JSElement[])node.getExpressions());
        }

        public void visitJSObjectLiteralExpression(JSObjectLiteralExpression node) {
            super.visitJSObjectLiteralExpression(node);
            this.applyTrailingCommaStyle(node.getPropertiesIncludingSpreads());
        }

        public void visitJSParameterList(JSParameterList node) {
            super.visitJSParameterList(node);
            if (this.myDialectOptionHolder.hasFeature(JSLanguageFeature.TRAILING_FUNCTION_COMMA)) {
                this.applyTrailingCommaStyle((JSElement[])node.getParameters());
            }
        }

        public void visitJSArgumentList(JSArgumentList node) {
            super.visitJSArgumentList(node);
            if (this.myDialectOptionHolder.hasFeature(JSLanguageFeature.TRAILING_FUNCTION_COMMA)) {
                this.applyTrailingCommaStyle((JSElement[])node.getArguments());
            }
        }

        public void visitJSDestructuringObject(JSDestructuringObject destructuringObject) {
            super.visitJSDestructuringObject(destructuringObject);
            this.applyTrailingCommaStyle((JSElement[])destructuringObject.getProperties());
        }

        public void visitJSDestructuringArray(JSDestructuringArray destructuringArray) {
            super.visitJSDestructuringArray(destructuringArray);
            this.applyTrailingCommaStyle((JSElement)ObjectUtils.coalesce((Object)destructuringArray.getRestElement(), (Object)ArrayUtil.getLastElement((Object[])destructuringArray.getElements())));
        }

        private void applyJSXQuoteStyle(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "applyJSXQuoteStyle"));
            }
            if (this.myHtmlQuoteStyle == CodeStyleSettings.QuoteStyle.None || !this.myEnforceHtmlQuotes) {
                return;
            }
            element.accept((PsiElementVisitor)this.myQuotesConverter);
        }

        private void applyJavaScriptQuoteStyle(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "applyJavaScriptQuoteStyle"));
            }
            if (!this.languageSettings.FORCE_QUOTE_STYlE || !this.containedInRange(element)) {
                return;
            }
            ASTNode node = element.getNode();
            if (!JSTokenTypes.STRING_LITERALS.contains(node.getElementType())) {
                return;
            }
            String stringValue = node.getText();
            if (this.languageSettings.USE_DOUBLE_QUOTES == JSStringUtil.isDoubleQuotedString(stringValue)) {
                return;
            }
            String result = JSStringUtil.changeQuotes(stringValue);
            if (stringValue.equals(result)) {
                return;
            }
            this.replaceNode(node, result);
        }

        private void applySemicolonStyle(@NotNull JSElement node) {
            boolean needSemicolon;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "applySemicolonStyle"));
            }
            if (!this.languageSettings.FORCE_SEMICOLON_STYLE || !this.containedInRange((PsiElement)node) || PsiTreeUtil.getDeepestLast((PsiElement)node) instanceof PsiErrorElement) {
                return;
            }
            ASTNode lastLeafElement = node.getLastChild().getNode();
            boolean hasSemicolon = lastLeafElement.getElementType() == JSTokenTypes.SEMICOLON;
            if (hasSemicolon == (needSemicolon = this.languageSettings.USE_SEMICOLON_AFTER_STATEMENT)) {
                return;
            }
            if (needSemicolon) {
                this.insertString(lastLeafElement.getStartOffset() + lastLeafElement.getTextLength(), ";");
            } else if (JSEnforceCodeStylePostProcessor.isSafeToDeleteSemicolon(node)) {
                this.replaceNode(lastLeafElement, "");
            }
        }

        private void applyTrailingCommaStyle(@NotNull JSElement[] listChildren) {
            if (listChildren == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listChildren", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "applyTrailingCommaStyle"));
            }
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])listChildren));
        }

        private void applyTrailingCommaStyle(@Nullable JSElement lastListElement) {
            boolean hasTrailingComma;
            if (this.languageSettings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Keep) {
                return;
            }
            if (lastListElement == null || !this.containedInRange((PsiElement)lastListElement)) {
                return;
            }
            PsiElement possiblyComma = JSPsiImplUtils.findNextCodeElement((PsiElement)lastListElement);
            PsiElement nextElement = lastListElement.getNextSibling();
            boolean bl = hasTrailingComma = possiblyComma != null && possiblyComma.getNode().getElementType() == JSTokenTypes.COMMA;
            if (hasTrailingComma && this.languageSettings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.Remove) {
                this.replaceNode(possiblyComma.getNode(), "");
            } else if (!hasTrailingComma) {
                boolean needsComma;
                boolean bl2 = needsComma = this.languageSettings.ENFORCE_TRAILING_COMMA == JSCodeStyleSettings.TrailingCommaOption.WhenMultiline && nextElement instanceof PsiWhiteSpace && nextElement.getText().contains("\n") && !JSEnforceCodeStylePostProcessor.isDestructuringRest(lastListElement);
                if (needsComma) {
                    this.insertString(lastListElement.getTextRange().getEndOffset(), ",");
                }
            }
        }

        private void insertString(int offset, String result) {
            int actualOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(actualOffset, (CharSequence)result);
            this.myPostProcessorHelper.updateResultRange(0, result.length());
        }

        private void replaceNode(ASTNode node, String result) {
            TextRange range = this.myPostProcessorHelper.mapRange(node.getTextRange());
            this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)result);
            this.myPostProcessorHelper.updateResultRange(node.getTextLength(), result.length());
        }

        private boolean containedInRange(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor", "containedInRange"));
            }
            return this.myOriginalRange.contains(element.getTextRange());
        }
    }
}

