/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class PostFormatProcessorUtil {
    private PostFormatProcessorUtil() {
    }

    @NotNull
    public static PsiElement processElement(@NotNull PsiElement source, @NotNull BiFunction<PsiElement, TextRange, TextRange> handler) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processElement"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processElement"));
        }
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            handler.apply(source, source.getTextRange());
            PsiElement psiElement = source;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processElement"));
            }
            return psiElement;
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            new InXmlProcessor(handler).processElementRange(source, source.getTextRange());
            PsiElement psiElement = source;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processElement"));
        }
        return psiElement;
    }

    @NotNull
    public static TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull BiFunction<PsiElement, TextRange, TextRange> handler) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
        }
        if (rangeToReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
        }
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            TextRange textRange = handler.apply((PsiElement)source, rangeToReformat);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
            }
            return textRange;
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            TextRange textRange = new InXmlProcessor(handler).processElementRange((PsiElement)source, rangeToReformat);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
            }
            return textRange;
        }
        List files = source.getViewProvider().getAllFiles();
        for (PsiFile file : files) {
            Language templateLang = file.getLanguage();
            if (templateLang.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                TextRange textRange = handler.apply((PsiElement)file, rangeToReformat);
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
                }
                return textRange;
            }
            if (!(templateLang instanceof XMLLanguage)) continue;
            TextRange textRange = new InXmlProcessor(handler).processElementRange((PsiElement)file, rangeToReformat);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil", "processText"));
        }
        return textRange;
    }

    private static class InXmlProcessor
    extends XmlRecursiveElementVisitor {
        private TextRange currentRange;
        private final BiFunction<PsiElement, TextRange, TextRange> myHandler;

        public InXmlProcessor(BiFunction<PsiElement, TextRange, TextRange> handler) {
            this.myHandler = handler;
        }

        public void visitXmlText(XmlText text) {
            this.processInjected((PsiElement)text);
        }

        public void processInjected(PsiElement element) {
            List pairs = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element);
            if (pairs == null) {
                return;
            }
            for (Pair pair : pairs) {
                int relEnd;
                int relStart;
                if (!(pair.getFirst() instanceof PsiFile)) continue;
                PsiFile jsFile = (PsiFile)pair.getFirst();
                int jsFileOffset = element.getTextOffset();
                TextRange initialRange = this.currentRange;
                if (initialRange != null) {
                    relStart = initialRange.getStartOffset() - jsFileOffset;
                    if (relStart < 0) {
                        relStart = 0;
                    }
                    if ((relEnd = initialRange.getEndOffset() - jsFileOffset) < 0) {
                        return;
                    }
                    if (relEnd > jsFile.getTextLength()) {
                        relEnd = jsFile.getTextLength();
                    }
                    if (relStart > relEnd) {
                        return;
                    }
                } else {
                    relStart = 0;
                    relEnd = jsFile.getTextLength();
                }
                this.myHandler.apply((PsiElement)jsFile, new TextRange(relStart, relEnd));
            }
        }

        public void visitElement(PsiElement element) {
            ASTNode node = element.getNode();
            if (node != null && node.getElementType() == JSElementTypes.EMBEDDED_CONTENT) {
                this.myHandler.apply(element, this.currentRange);
            }
            super.visitElement(element);
        }

        public TextRange processElementRange(PsiElement source, TextRange rangeToReformat) {
            this.currentRange = rangeToReformat;
            source.accept((PsiElementVisitor)this);
            return this.currentRange;
        }
    }
}

