/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.frameworks.amd.JSAmdIndexingHandler;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSNonFileAmdModuleReference
extends PsiPolyVariantReferenceBase<JSLiteralExpression>
implements JSModuleBaseReference {
    private static final ResolveCache.PolyVariantResolver<JSNonFileAmdModuleReference> MY_RESOLVER = new ResolveCache.PolyVariantResolver<JSNonFileAmdModuleReference>(){

        @NotNull
        public ResolveResult[] resolve(@NotNull JSNonFileAmdModuleReference ref, boolean incompleteCode) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference$1", "resolve"));
            }
            ResolveResult[] resolveResultArray = ref.resolveInner();
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference$1", "resolve"));
            }
            return resolveResultArray;
        }
    };

    public JSNonFileAmdModuleReference(@NotNull JSLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference", "<init>"));
        }
        super((PsiElement)element, true);
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((JSLiteralExpression)this.getElement()).getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private ResolveResult[] resolveInner() {
        JSLiteralExpression element = (JSLiteralExpression)this.getElement();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)element);
        THashMap pathAliases = new THashMap();
        StubIndex.getInstance().processElements(JSAmdRequirePathIndex.KEY, (Object)"jsRequirePathAliases", element.getProject(), scope, JSImplicitElementProvider.class, arg_0 -> JSNonFileAmdModuleReference.lambda$resolveInner$0((Map)pathAliases, arg_0));
        String moduleAlias = StringUtil.unquoteString((String)element.getText());
        VirtualFile contextVirtualFile = element.getContainingFile().getViewProvider().getVirtualFile();
        PsiManager manager = element.getManager();
        VirtualFile closest = null;
        SmartList candidateResults = new SmartList();
        for (Map.Entry entry : pathAliases.entrySet()) {
            Map<String, String> aliases;
            String alias;
            String serializedAliasesMap = (String)entry.getValue();
            if (!serializedAliasesMap.contains(moduleAlias)) continue;
            VirtualFile file = (VirtualFile)entry.getKey();
            boolean overwriteIfFound = false;
            if (closest != null) {
                int compare = JSAmdUtil.compareClosenessesToContext(file, closest, contextVirtualFile);
                if (compare < 0) {
                    overwriteIfFound = true;
                } else if (compare > 0) continue;
            }
            if ((alias = (aliases = JSAmdIndexingHandler.deserializeMap(serializedAliasesMap)).get(moduleAlias)) == null) continue;
            String path = alias + ".js";
            VirtualFile[] includingFilesArray = FileIncludeManager.getManager((Project)element.getProject()).getIncludingFiles(file, false);
            ArrayList<VirtualFile> includingFiles = new ArrayList<VirtualFile>(includingFilesArray.length + 1);
            includingFiles.add(file);
            includingFiles.addAll(Arrays.asList(includingFilesArray));
            for (VirtualFile includingFile : includingFiles) {
                PsiFile psiFile;
                VirtualFile referencedFile;
                if (includingFile.getFileType() != HtmlFileType.INSTANCE) continue;
                Ref dataMainValue = Ref.create(null);
                FileBasedIndex.getInstance().processValues(JSCustomSingleEntriesIndex.INDEX_ID, (Object)"js.require.data.main", includingFile, (file1, value) -> {
                    dataMainValue.set(value);
                    return false;
                }, scope);
                VirtualFile baseFileDir = includingFile.getParent();
                if (!dataMainValue.isNull()) {
                    String dataMainPath = (String)dataMainValue.get() + ".js";
                    VirtualFile mainFilePath = includingFile.getParent().findFileByRelativePath(dataMainPath);
                    if (mainFilePath != null) {
                        baseFileDir = mainFilePath.getParent();
                    }
                }
                if (baseFileDir == null || (referencedFile = baseFileDir.findFileByRelativePath(path)) == null || (psiFile = manager.findFile(referencedFile)) == null) continue;
                closest = referencedFile;
                if (overwriteIfFound) {
                    candidateResults.clear();
                }
                candidateResults.add(psiFile);
            }
        }
        String moduleName = JSAmdPsiUtil.unifyModuleName(element);
        Collection<JSPsiElementBase> candidates = JSClassResolver.findElementsByNameIncludingImplicit(moduleName, scope, false);
        for (JSPsiElementBase candidate : candidates) {
            if (!(candidate instanceof JSImplicitElement) || !JSAmdPsiUtil.isAmdModuleName((JSImplicitElement)candidate)) continue;
            candidateResults.add(candidate);
        }
        if (!candidateResults.isEmpty()) {
            ResolveResult[] results = new ResolveResult[candidateResults.size()];
            for (int i = 0; i < candidateResults.size(); ++i) {
                results[i] = new PsiElementResolveResult((PsiElement)candidateResults.get(i));
            }
            return results;
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ boolean lambda$resolveInner$0(Map pathAliases, JSImplicitElementProvider provider) {
        Collection elements;
        JSElementIndexingData data = provider.getIndexingData();
        Collection collection = elements = data != null ? data.getImplicitElements() : null;
        if (elements != null) {
            for (JSImplicitElement element1 : elements) {
                if (!"jsRequirePathAliases".equals(element1.getName()) || !"arp".equals(element1.getUserString())) continue;
                pathAliases.put(provider.getContainingFile().getVirtualFile(), element1.getTypeString());
            }
        }
        return true;
    }
}

