/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefaultModuleReferenceContributor
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = this.getReferences(unquotedRefText, host, offset, provider, false);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript(host);
    }

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        PsiReference[] psiReferenceArray = this.getReferences(unquotedRefText, host, offset, provider, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider, boolean isCommonJS) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getReferences"));
        }
        Pair<Integer, String> path = JSModuleReferenceContributor.getActualPath(unquotedRefText);
        String modulePath = (String)path.second;
        Integer resourcePathStartInd = (Integer)path.first;
        int index = resourcePathStartInd + offset;
        final boolean isSoft = JSDefaultModuleReferenceContributor.isSoft(host, modulePath, isCommonJS);
        FileReference[] fileReferenceArray = new JSModuleFileReferenceSet(modulePath, host, index, provider, JSDefaultModuleReferenceContributor.getFileTemplateName(host, isCommonJS)){

            protected boolean isSoft() {
                return isSoft;
            }
        }.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getReferences"));
        }
        return fileReferenceArray;
    }

    private static boolean isSoft(@NotNull PsiElement host, @NotNull String modulePath, boolean isCommonJS) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "isSoft"));
        }
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "isSoft"));
        }
        if (!isCommonJS) {
            return !JSModuleFileReferenceSet.isRelative(modulePath);
        }
        if (!NodeModuleSearchUtil.isFileModuleRequired(modulePath)) {
            return true;
        }
        PsiFile file = host.getContainingFile();
        if (file != null) {
            file = file.getOriginalFile();
        }
        if (file != null && file.isValid()) {
            return !NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(file);
        }
        return false;
    }

    @Nullable
    private static String getFileTemplateName(@NotNull PsiElement host, boolean isCommonJS) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/modules/JSDefaultModuleReferenceContributor", "getFileTemplateName"));
        }
        boolean supportsNativeModules = JSRootConfiguration.getInstance(host.getProject()).getLanguageLevel().isES6Compatible();
        return supportsNativeModules || isCommonJS ? null : "AMD JavaScript File.js";
    }
}

