/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleFileReferenceSet
extends FileReferenceSet {
    private final String myExplicitNewFileTemplate;

    public JSModuleFileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, @Nullable String explicitNewFileTemplate) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, false, true, FileType.EMPTY_ARRAY, false);
        this.myExplicitNewFileTemplate = explicitNewFileTemplate;
        this.reparse();
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        if (this.isAbsolutePathReference()) {
            LinkedHashSet result = ContainerUtil.newLinkedHashSet((Iterable)super.computeDefaultContexts());
            result.addAll(this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots()));
            LinkedHashSet linkedHashSet = result;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "computeDefaultContexts"));
            }
            return linkedHashSet;
        }
        if (JSModuleFileReferenceSet.isRelative(this.getPathString())) {
            Collection collection = super.computeDefaultContexts();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }
        PsiElement element = this.getElement();
        Project project = element.getProject();
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        JSModuleFileReferenceSet.addNodeModulesDirContexts(project, element, result, this);
        result.addAll(JSAmdUtil.getBaseDirectories(element));
        result.addAll(this.getParentDirectoryContext());
        PsiFile file = this.getContainingFile();
        if (file != null) {
            JSModuleFileReferenceSet.addDefaultRoots(project, file, result);
        }
        result.addAll(super.computeDefaultContexts());
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "computeDefaultContexts"));
        }
        return linkedHashSet;
    }

    private static void addDefaultRoots(@NotNull Project project, @NotNull PsiFile file, @NotNull Collection<PsiFileSystemItem> result) {
        VirtualFile[] roots;
        ModuleRootManager rootManager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addDefaultRoots"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addDefaultRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addDefaultRoots"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        PsiManager manager = file.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null && (rootManager = ModuleRootManager.getInstance((Module)module)) != null && (roots = rootManager.getSourceRoots()).length > 0) {
            for (VirtualFile root : roots) {
                ContainerUtil.addIfNotNull(result, (Object)manager.findDirectory(root));
            }
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRoot = index.getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            ContainerUtil.addIfNotNull(result, (Object)manager.findDirectory(contentRoot));
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new JSModuleReference(text, i, textRange, this, this.myExplicitNewFileTemplate, this.isSoft());
    }

    public static void addNodeModulesDirContexts(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result, @NotNull FileReferenceSet referenceSet) {
        String firstRefText;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesDirContexts"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesDirContexts"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesDirContexts"));
        }
        if (referenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceSet", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesDirContexts"));
        }
        FileReference firstRef = (FileReference)ArrayUtil.getFirstElement((Object[])referenceSet.getAllReferences());
        String string = firstRefText = firstRef != null ? firstRef.getText() : null;
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        VirtualFile localNodeModulesDir = JSModuleFileReferenceSet.findUpNodeModules(element);
        if (localNodeModulesDir == null) {
            JSModuleFileReferenceSet.addNodeModulesContextsFromIndexes(project, element, result, firstRefText);
        } else {
            VirtualFile current = localNodeModulesDir;
            while (current != null) {
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(current);
                JSModuleFileReferenceSet.doAddNodeModulesContext(current, packageJson, firstRefText, result, element.getManager());
                VirtualFile parent = current.getParent();
                current = parent == null ? null : NodeModuleUtil.findUpClosestNodeModulesResolveRoot(parent);
            }
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result, localNodeModulesDir);
        }
    }

    private static void addNodeModulesContextsFromIndexes(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result, String firstRefText) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesContextsFromIndexes"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesContextsFromIndexes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addNodeModulesContextsFromIndexes"));
        }
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile file : files) {
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file);
            if (nodeModulesDir == null) continue;
            JSModuleFileReferenceSet.doAddNodeModulesContext(nodeModulesDir, file, firstRefText, result, element.getManager());
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result, nodeModulesDir);
        }
    }

    @Nullable
    private static VirtualFile findUpNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "findUpNodeModules"));
        }
        VirtualFile currentFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        if (currentFile != null) {
            return NodeModuleUtil.findUpClosestNodeModulesResolveRoot(currentFile);
        }
        return null;
    }

    private static void doAddNodeModulesContext(@NotNull VirtualFile nodeModulesDir, @Nullable VirtualFile packageJson, @NotNull String firstRefText, @NotNull Collection<PsiFileSystemItem> result, @NotNull PsiManager psiManager) {
        PackageJsonData data;
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "doAddNodeModulesContext"));
        }
        if (firstRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstRefText", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "doAddNodeModulesContext"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "doAddNodeModulesContext"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "doAddNodeModulesContext"));
        }
        if (packageJson != null && !(data = PackageJsonUtil.getOrCreateData(packageJson)).containsDependencyWithScope(firstRefText) && !data.isDependencyOfAnyType(firstRefText)) {
            return;
        }
        PsiDirectory directory = psiManager.findDirectory(nodeModulesDir);
        if (directory != null) {
            result.add((PsiFileSystemItem)directory);
        }
    }

    public static void addTypesForNodeModulesDir(@NotNull PsiElement context, @NotNull Collection<PsiFileSystemItem> altResolveModules, @Nullable VirtualFile nodeModulesDirectories) {
        PsiDirectory typesModules;
        VirtualFile typesFile;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addTypesForNodeModulesDir"));
        }
        if (altResolveModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "altResolveModules", "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet", "addTypesForNodeModulesDir"));
        }
        if (nodeModulesDirectories != null && (typesFile = nodeModulesDirectories.findChild("@types")) != null && (typesModules = context.getManager().findDirectory(typesFile)) != null) {
            altResolveModules.add((PsiFileSystemItem)typesModules);
        }
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    public static boolean isRelative(String pathString) {
        return pathString.endsWith(".js") || pathString.startsWith(".");
    }
}

