/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementNSDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlElementDescriptor
implements XmlElementDescriptor {
    private static final Collection<String> IGNORED_ATTRIBUTES = ContainerUtil.immutableSet((Object[])new String[]{"class", "for"});
    @NotNull
    private final String myName;
    @NotNull
    private final PsiElement myContext;
    private final boolean myStrict;
    @Nullable
    private final ReactXmlElementNSDescriptor myDescriptor;
    @Nullable
    private final XmlNSDescriptor myParentNSDescriptor;

    public ReactXmlElementDescriptor(@NotNull String name, @NotNull PsiElement context, @Nullable XmlNSDescriptor parentNSDescriptor, boolean isStrict) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "<init>"));
        }
        this.myName = name;
        this.myContext = context;
        this.myParentNSDescriptor = parentNSDescriptor;
        this.myStrict = isStrict;
        this.myDescriptor = new ReactXmlElementNSDescriptor(parentNSDescriptor, this.myContext, isStrict);
    }

    public String getQualifiedName() {
        return this.myName;
    }

    public String getDefaultName() {
        return this.myName;
    }

    public XmlElementDescriptor[] getElementsDescriptors(XmlTag context) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        if (descriptor == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        return descriptor.getRootElementsDescriptors(null);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag childTag, XmlTag contextTag) {
        XmlNSDescriptor descriptor = this.getNSDescriptor();
        return descriptor.getElementDescriptor(childTag);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        if (context == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.getComponentProps(context);
        }
        return this.resolveTagAttributes(context);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if (context == null) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        if (ReactXmlExtension.isComponentName(context.getName())) {
            return ReactXmlElementDescriptor.findComponentProp(attributeName, context);
        }
        return this.resolveTagAttribute(context, attributeName);
    }

    @Nullable
    private static XmlAttributeDescriptor findComponentProp(@NonNls String attributeName, @NotNull XmlTag context) {
        XmlAttributeDescriptor descriptor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "findComponentProp"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context) && (descriptor = TypeScriptReactTagUtil.getXmlAttributeDescriptor(attributeName, TypeScriptReactComponentUtil.getGenericPropType(context))) != null) {
            return descriptor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)context);
        Ref declaration = Ref.create();
        NamespaceInfo namespace = ReactXmlElementDescriptor.getPropsNamespace(context);
        JSClassResolver.getInstance().processNamespaceMembers(namespace.myNamespace, scope, (Processor<JSPsiElementBase>)((Processor)base -> {
            if (attributeName.equals(base.getName())) {
                declaration.set(base);
            }
            return declaration.isNull();
        }));
        if (!declaration.isNull()) {
            return ReactAttributeDescriptor.create(attributeName, (PsiElement)declaration.get(), namespace.myIsWeakResolve);
        }
        return new AnyXmlAttributeDescriptor(attributeName);
    }

    private static XmlAttributeDescriptor[] getComponentProps(@NotNull XmlTag context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getComponentProps"));
        }
        if (DialectDetector.isTypeScript((PsiElement)context)) {
            JSType type = TypeScriptReactComponentUtil.getGenericPropType(context);
            return TypeScriptReactTagUtil.getXmlAttributeDescriptors(type);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)context);
        NamespaceInfo namespace = ReactXmlElementDescriptor.getPropsNamespace(context);
        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findNamespaceMembers(namespace.myNamespace, scope);
        if (!members.isEmpty()) {
            return (XmlAttributeDescriptor[])ContainerUtil.map2Array(members, XmlAttributeDescriptor.class, base -> ReactAttributeDescriptor.create(base.getName(), (PsiElement)base));
        }
        return XmlAttributeDescriptor.EMPTY;
    }

    @NotNull
    private static NamespaceInfo getPropsNamespace(@NotNull XmlTag context) {
        JSType type;
        JSField props;
        String name;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        PsiReference reference = context.getReference();
        PsiNamedElement component = null;
        boolean isWeakResolve = false;
        if (reference != null) {
            PsiElement resolve = reference.resolve();
            Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(resolve, false);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            if (item instanceof JSCallExpression) {
                isWeakResolve = true;
                item = (PsiElement)ContainerUtil.getFirstItem(ReactXmlExtension.resolveCallExpression((JSCallExpression)item));
            }
            component = (PsiNamedElement)ObjectUtils.tryCast((Object)item, PsiNamedElement.class);
        }
        if (component != null && component.getName() != null) {
            name = component.getName();
        } else {
            name = context.getName();
            isWeakResolve = true;
        }
        String namespace = name + ".props";
        if (component instanceof JSClass && (props = ((JSClass)component).findFieldByName("props")) != null && (type = props.getType()) instanceof JSNamedType) {
            namespace = type.getTypeText();
        }
        NamespaceInfo namespaceInfo = new NamespaceInfo(namespace, isWeakResolve);
        if (namespaceInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getPropsNamespace"));
        }
        return namespaceInfo;
    }

    @NotNull
    private XmlAttributeDescriptor[] resolveTagAttributes(XmlTag context) {
        XmlAttributeDescriptor[] typeScriptProperties = ReactXmlElementDescriptor.getPropertyAttributes(context);
        XmlElementDescriptor elementDescriptor = this.getXmlElementDescriptorFormParent(context);
        if (elementDescriptor != null && !(elementDescriptor instanceof ReactXmlElementDescriptor)) {
            XmlAttributeDescriptor[] xmlAttributeDescriptorArray = this.mergeAttributes(typeScriptProperties, elementDescriptor.getAttributesDescriptors(context));
            if (xmlAttributeDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "resolveTagAttributes"));
            }
            return xmlAttributeDescriptorArray;
        }
        if (typeScriptProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "resolveTagAttributes"));
        }
        return typeScriptProperties;
    }

    private static XmlAttributeDescriptor[] getPropertyAttributes(XmlTag context) {
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        XmlAttributeDescriptor[] typeScriptProperties = XmlAttributeDescriptor.EMPTY;
        if (property != null) {
            typeScriptProperties = TypeScriptReactTagUtil.getXmlAttributeDescriptors(property);
        }
        return typeScriptProperties;
    }

    protected XmlAttributeDescriptor[] mergeAttributes(@NotNull XmlAttributeDescriptor[] typeScriptProperties, @NotNull XmlAttributeDescriptor[] parentDescriptors) {
        if (typeScriptProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeScriptProperties", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "mergeAttributes"));
        }
        if (parentDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDescriptors", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "mergeAttributes"));
        }
        if (parentDescriptors.length == 0) {
            return typeScriptProperties;
        }
        if (typeScriptProperties.length == 0) {
            return parentDescriptors;
        }
        ArrayList result = ContainerUtil.newArrayList((Object[])typeScriptProperties);
        Set names = Arrays.stream(typeScriptProperties).map(el -> StringUtil.toLowerCase((String)el.getName())).collect(Collectors.toSet());
        for (XmlAttributeDescriptor descriptor : parentDescriptors) {
            String name = descriptor.getName();
            if (IGNORED_ATTRIBUTES.contains(name) || names.contains(ReactXmlElementDescriptor.normalizeAttributeName(name))) continue;
            result.add(descriptor);
        }
        return result.toArray(XmlAttributeDescriptor.EMPTY);
    }

    private XmlAttributeDescriptor resolveTagAttribute(XmlTag context, @NonNls String attributeName) {
        XmlElementDescriptor elementDescriptor;
        boolean hasTypeScriptDeclarations;
        TypeScriptPropertySignature property = TypeScriptReactTagUtil.resolveTag(context);
        boolean bl = hasTypeScriptDeclarations = property != null;
        if (hasTypeScriptDeclarations) {
            Ref resultRef = Ref.create();
            HashSet lowCaseNames = ContainerUtil.newHashSet();
            TypeScriptReactTagUtil.processAttributes(property, (Processor<JSRecordType.PropertySignature>)((Processor)el -> {
                String name = el.getMemberName();
                if (name.equals(attributeName)) {
                    resultRef.set((Object)TypeScriptReactTagUtil.createAttributeDescriptor(el, false));
                    return false;
                }
                lowCaseNames.add(StringUtil.toLowerCase((String)name));
                return true;
            }));
            if (!resultRef.isNull() || lowCaseNames.contains(ReactXmlElementDescriptor.normalizeAttributeName(StringUtil.toLowerCase((String)attributeName))) || IGNORED_ATTRIBUTES.contains(attributeName)) {
                return resultRef.isNull() ? null : (XmlAttributeDescriptor)resultRef.get();
            }
        }
        if ((elementDescriptor = this.getXmlElementDescriptorFormParent(context)) != null) {
            if (!(elementDescriptor instanceof ReactXmlElementDescriptor)) {
                XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attributeName, context);
                return attributeDescriptor != null ? attributeDescriptor : ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
            }
            return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
        }
        return ReactXmlElementDescriptor.getEmptyAttributeValue(attributeName, hasTypeScriptDeclarations);
    }

    private static String normalizeAttributeName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "normalizeAttributeName"));
        }
        return attributeName.replace("-", "");
    }

    @Nullable
    private static XmlAttributeDescriptor getEmptyAttributeValue(@NotNull String attributeName, boolean strict) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getEmptyAttributeValue"));
        }
        return strict ? null : new AnyXmlAttributeDescriptor(attributeName);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(XmlAttribute attribute) {
        return this.getAttributeDescriptor(attribute.getName(), attribute.getParent());
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDescriptor;
    }

    @Nullable
    public XmlElementsGroup getTopGroup() {
        return null;
    }

    public int getContentType() {
        return ReactXmlExtension.isComponentName(this.myName) ? 0 : 1;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        if (!this.myStrict && this.myContext instanceof XmlTag && !ReactXmlExtension.isComponentName(this.myName) && (descriptor = this.getXmlElementDescriptorFormParent((XmlTag)this.myContext)) != null && !(descriptor instanceof ReactXmlElementDescriptor) && (declaration = descriptor.getDeclaration()) != null) {
            return declaration;
        }
        return this.myContext;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getName"));
        }
        return string;
    }

    public void init(PsiElement element) {
    }

    private XmlElementDescriptor getXmlElementDescriptorFormParent(@Nullable XmlTag context) {
        if (context == null || this.myParentNSDescriptor == null) {
            return null;
        }
        return this.myParentNSDescriptor.getElementDescriptor(context);
    }

    @NotNull
    public Object[] getDependences() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/ReactXmlElementDescriptor", "getDependences"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    static class NamespaceInfo {
        private final String myNamespace;
        private final boolean myIsWeakResolve;

        public NamespaceInfo(String namespace, boolean isWeakResolve) {
            this.myNamespace = namespace;
            this.myIsWeakResolve = isWeakResolve;
        }
    }
}

