/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react.tsx;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReactComponentUtil {
    public static final String ELEMENT_CLASS_NAME = "ElementClass";
    public static final String REACT_COMPONENT_NAME = "Component";
    public static final String PROPS_FIELD_NAME = "props";

    @Nullable
    public static JSClass findReactClass(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "findReactClass"));
        }
        Collection candidates = StubIndex.getElements(JSClassIndex.KEY, (Object)"^ElementClass", (Project)context.getProject(), (GlobalSearchScope)JSResolveUtil.getResolveScope(context), JSElement.class);
        for (JSElement aClass : candidates) {
            Object[] superClasses;
            if (!(aClass instanceof TypeScriptInterface) || (superClasses = ((TypeScriptInterface)aClass).getSuperClasses()).length != 1) continue;
            return (JSClass)ArrayUtil.getFirstElement((Object[])superClasses);
        }
        return null;
    }

    @NotNull
    public static Collection<JSClass> resolveComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "resolveComponent"));
        }
        JSTypeResolveResult result = TypeScriptImportHandler.getInstance().resolveName(tag.getName(), (PsiElement)tag);
        ArrayList toReturn = ContainerUtil.newArrayList();
        for (PsiElement psiElement : result.getElements()) {
            JSClass jsClass;
            if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface()) continue;
            toReturn.add(jsClass);
        }
        ArrayList arrayList = toReturn;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "resolveComponent"));
        }
        return arrayList;
    }

    public static JSType getGenericPropType(XmlTag tag) {
        if (!DialectDetector.isTypeScript((PsiElement)tag)) {
            return null;
        }
        PsiReference reference = tag.getReference();
        if (reference == null) {
            return null;
        }
        PsiElement resolveCandidate = reference.resolve();
        Collection<PsiElement> elements = ReactXmlExtension.getElementsByImport(resolveCandidate, false);
        for (PsiElement resolve : elements) {
            JSType result;
            Collection<PsiElement> items;
            boolean forceOptional = false;
            if (resolve instanceof JSCallExpression && (items = ReactXmlExtension.resolveCallExpression((JSCallExpression)resolve)).size() == 1) {
                resolve = (PsiElement)ContainerUtil.getFirstItem(items);
                forceOptional = true;
            }
            if ((result = TypeScriptReactComponentUtil.getTypeFromPsiElement(resolve)) == null) continue;
            return forceOptional ? result.copyWithExplicitlyDeclared(false) : result;
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromPsiElement(PsiElement resolve) {
        JSParameterListElement[] parameters;
        if (resolve instanceof JSVariable) {
            resolve = ((JSVariable)resolve).tryGetFunctionExpressionInitializer();
        }
        if (resolve instanceof JSClass) {
            Pair<JSClass, JSType> type = TypeScriptReactComponentUtil.getPropsType((JSClass)resolve);
            if (type != null && type.second != null) {
                return TypeScriptUtil.applyGenericsToType((JSType)type.second, (JSClass)resolve, (JSClass)type.first);
            }
        } else if (resolve instanceof JSFunction && (parameters = ((JSFunction)resolve).getParameters()).length == 1) {
            return parameters[0].getType();
        }
        return null;
    }

    @Nullable
    public static Pair<JSClass, JSType> getPropsType(@NotNull JSClass componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentClass", "com/intellij/lang/javascript/frameworks/react/tsx/TypeScriptReactComponentUtil", "getPropsType"));
        }
        for (JSClass<?> aClass : TypeScriptUtil.getNonStrictParents(componentClass, false)) {
            JSField props = aClass.findFieldByName(PROPS_FIELD_NAME);
            if (!REACT_COMPONENT_NAME.equals(aClass.getName()) || props == null) continue;
            return Pair.create(aClass, (Object)props.getType());
        }
        return null;
    }
}

