/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.webpack.WebpackConfigHighlightingInspection;
import com.intellij.lang.javascript.frameworks.webpack.WebpackUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackInJavaScriptJsonSchemaProvider
implements JsonSchemaInJavaScriptProvider {
    public static VirtualFile getWebpackSchemaFile() {
        return JsonSchemaProviderFactory.getResourceFile(WebpackInJavaScriptJsonSchemaProvider.class, (String)"/jsonSchemas/webpack-schema.json");
    }

    @Override
    public VirtualFile getSchemaFile() {
        return WebpackInJavaScriptJsonSchemaProvider.getWebpackSchemaFile();
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailable"));
        }
        return WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element) && WebpackInJavaScriptJsonSchemaProvider.isApplicable(element);
    }

    static boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isAvailableForFile"));
        }
        return Registry.is((String)"JavaScript.WebPack.With.JsonSchema", (boolean)true) && StringUtil.startsWithIgnoreCase((String)file.getName(), (String)"webpack") && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    public static boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isApplicable"));
        }
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && WebpackUtil.isWebpack2(element.getProject()) && WebpackInJavaScriptJsonSchemaProvider.isInSupportedArea(element) && WebpackInJavaScriptJsonSchemaProvider.isInTopLevelObject(element);
    }

    private static boolean isInTopLevelObject(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInTopLevelObject"));
        }
        for (current = element; !(current == null || JSJsonLikePsiWalker.isTerminalInStatement(current) || current instanceof PsiFile || current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (current instanceof JSProperty || current instanceof JSLiteralExpression || current instanceof JSObjectLiteralExpression || current instanceof JSArrayLiteralExpression || current instanceof JSReferenceExpression || current instanceof LeafPsiElement) {
                continue;
            }
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)current, JSObjectLiteralExpression.class) == null;
    }

    private static boolean isWebpackInspectionAllowed(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isWebpackInspectionAllowed"));
        }
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String name = InspectionProfileEntry.getShortName((String)WebpackConfigHighlightingInspection.class.getSimpleName());
        InspectionToolWrapper tool = profile.getInspectionTool(name, element.getProject());
        return profile.isToolEnabled(HighlightDisplayKey.find((String)name), element) && tool != null && !tool.getTool().isSuppressedFor(element);
    }

    private static boolean isInSupportedArea(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "isInSupportedArea"));
        }
        PsiFile file = (PsiFile)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInSupportedArea$0"));
            }
            if (element.getContainingFile() == null || !element.isValid() || !element.getContainingFile().isValid()) {
                return null;
            }
            if (JSTokenTypes.STRING_LITERAL.equals(element.getNode().getElementType())) {
                return null;
            }
            return element.getContainingFile();
        });
        if (file == null) {
            return false;
        }
        List ranges = (List)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create(WebpackInJavaScriptJsonSchemaProvider.getModuleExportsParts(file), (Object[])new Object[]{file}));
        return ContainerUtil.or((Iterable)ranges, range -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "lambda$isInSupportedArea$2"));
            }
            return range.contains(element.getTextRange());
        });
    }

    private static List<TextRange> getModuleExportsParts(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/webpack/WebpackInJavaScriptJsonSchemaProvider", "getModuleExportsParts"));
        }
        List assignmentCandidates = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSAssignmentExpression.class).stream().filter(assignment -> (assignment.getParent() instanceof JSStatement || assignment.getParent() instanceof JSCommaExpression) && assignment.getDefinitionExpression() != null && WebpackInJavaScriptJsonSchemaProvider.isModuleExports(assignment.getDefinitionExpression().getExpression())).collect(Collectors.toList());
        List directParts = assignmentCandidates.stream().filter(assignment -> {
            JSDefinitionExpression definition = assignment.getDefinitionExpression();
            return definition != null && (definition.getInitializer() instanceof JSObjectLiteralExpression || definition.getInitializer() instanceof JSArrayLiteralExpression);
        }).map(PsiElement::getTextRange).collect(Collectors.toList());
        List fromVariableReferences = assignmentCandidates.stream().filter(a -> a.getDefinitionExpression() != null).map(a -> WebpackInJavaScriptJsonSchemaProvider.getObjectLiteralFromReference(a.getDefinitionExpression().getInitializer())).filter(Objects::nonNull).map(PsiElement::getTextRange).collect(Collectors.toList());
        directParts.addAll(fromVariableReferences);
        List lists = PsiTreeUtil.findChildrenOfType((PsiElement)file, JSVariable.class).stream().filter(variable -> "webpackConfig".equalsIgnoreCase(variable.getName())).map(variable -> PsiTreeUtil.findChildrenOfAnyType((PsiElement)variable, (Class[])new Class[]{JSObjectLiteralExpression.class, JSArrayLiteralExpression.class})).filter(e -> e != null).collect(Collectors.toList());
        List fromVariable = ContainerUtil.concat(lists).stream().filter(Objects::nonNull).map(PsiElement::getTextRange).sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
        directParts.addAll(fromVariable);
        return directParts.stream().sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
    }

    private static JSExpression getObjectLiteralFromReference(@Nullable JSExpression initializer) {
        JSExpression varInitializer;
        PsiElement resolve;
        if (initializer instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)initializer).resolve()) != null && resolve.isValid() && resolve instanceof JSVariable && (varInitializer = ((JSVariable)resolve).getInitializer()) instanceof JSObjectLiteralExpression) {
            return varInitializer;
        }
        return null;
    }

    private static boolean isModuleExports(@Nullable JSExpression expression) {
        return expression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "module", "exports") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expression, "exports"));
    }
}

