/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.call.JSCalleeMethodsTreeStructure;
import com.intellij.lang.javascript.hierarchy.call.JSCallerMethodsTreeStructure;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.hierarchy.call.JSCallHierarchyBrowser");

    public JSCallHierarchyBrowser(Project project, JSFunction method) {
        super(project, (PsiElement)method);
    }

    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        if (type2TreeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2TreeMap", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "createTrees"));
        }
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("JSCallHierarchyPopupMenu");
        JTree tree1 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        CallHierarchyBrowserBase.BaseOnThisMethodAction baseOnThisMethodAction = new CallHierarchyBrowserBase.BaseOnThisMethodAction();
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), (JComponent)tree1);
        type2TreeMap.put(CALLEE_TYPE, tree1);
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"CallHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisMethodAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("CallHierarchy").getShortcutSet(), (JComponent)tree2);
        type2TreeMap.put(CALLER_TYPE, tree2);
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "isApplicableElement"));
        }
        return element instanceof JSFunction;
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "createHierarchyTreeStructure"));
        }
        if (CALLER_TYPE.equals(typeName)) {
            return new JSCallerMethodsTreeStructure(this.myProject, (JSFunction)psiElement, this.getCurrentScopeType());
        }
        if (CALLEE_TYPE.equals(typeName)) {
            return new JSCalleeMethodsTreeStructure(this.myProject, (JSFunction)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected Comparator<NodeDescriptor> getComparator() {
        return JSHierarchyUtils.getComparator(this.myProject);
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "getElementFromDescriptor"));
        }
        if (descriptor instanceof JSCallHierarchyNodeDescriptor) {
            JSCallHierarchyNodeDescriptor nodeDescriptor = (JSCallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getEnclosingElement();
        }
        return null;
    }

    @Nullable
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/hierarchy/call/JSCallHierarchyBrowser", "getOpenFileElementFromDescriptor"));
        }
        if (descriptor instanceof JSCallHierarchyNodeDescriptor) {
            JSCallHierarchyNodeDescriptor nodeDescriptor = (JSCallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getTargetElement();
        }
        return null;
    }
}

